/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.visit;

import org.eclipse.persistence.tools.oracleddl.metadata.BinaryType;
import org.eclipse.persistence.tools.oracleddl.metadata.BlobType;
import org.eclipse.persistence.tools.oracleddl.metadata.CharType;
import org.eclipse.persistence.tools.oracleddl.metadata.ClobType;
import org.eclipse.persistence.tools.oracleddl.metadata.LongRawType;
import org.eclipse.persistence.tools.oracleddl.metadata.LongType;
import org.eclipse.persistence.tools.oracleddl.metadata.NCharType;
import org.eclipse.persistence.tools.oracleddl.metadata.NClobType;
import org.eclipse.persistence.tools.oracleddl.metadata.NVarChar2Type;
import org.eclipse.persistence.tools.oracleddl.metadata.RawType;
import org.eclipse.persistence.tools.oracleddl.metadata.URowIdType;
import org.eclipse.persistence.tools.oracleddl.metadata.VarChar2Type;
import org.eclipse.persistence.tools.oracleddl.metadata.VarCharType;
import org.eclipse.persistence.tools.oracleddl.test.visit.SizedTypeVisitor;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SizedTypeTest {
    protected static long L10 = 10L;
    protected static long L12 = 12L;
    protected static long L4001 = 4001L;
    protected static String BINARY = "BINARY";
    protected static String BINARY_10 = "BINARY(10)";
    protected static String BLOB = "BLOB";
    protected static String BLOB_10 = "BLOB(10)";
    protected static String LONG_RAW = "LONG RAW";
    protected static String LONG_RAW_10 = "LONG RAW(10)";
    protected static String RAW = "RAW";
    protected static String RAW_10 = "RAW(10)";
    protected static String CHAR = "CHAR";
    protected static String CHAR_12 = "CHAR(12)";
    protected static String NCHAR = "NCHAR";
    protected static String NCHAR_12 = "NCHAR(12)";
    protected static String CLOB = "CLOB";
    protected static String CLOB_10 = "CLOB(10)";
    protected static String NCLOB = "NCLOB";
    protected static String UROWID = "UROWID";
    protected static String UROWID_4001 = "UROWID(4001)";
    protected static String VARCHAR = "VARCHAR";
    protected static String VARCHAR_10 = "VARCHAR(10)";
    protected static String VARCHAR2 = "VARCHAR2";
    protected static String VARCHAR2_10 = "VARCHAR2(10)";
    protected static String LONG = "LONG";
    protected static String LONG_10 = "LONG(10)";
    protected static String NVARCHAR2 = "NVARCHAR2";
    protected static String NVARCHAR2_10 = "NVARCHAR2(10)";
    protected static SizedTypeVisitor visitor;

    @BeforeClass
    public static void setUp() {
        visitor = new SizedTypeVisitor();
    }

    @Test
    public void testBinaryType() {
        BinaryType binaryType = new BinaryType();
        binaryType.accept(visitor);
        Assert.assertEquals((String)"BinaryType() test failed:\n", (Object)visitor.toString(), (Object)BINARY);
        binaryType = new BinaryType(L10);
        binaryType.accept(visitor);
        Assert.assertEquals((String)"BinaryType(L10) test failed:\n", (Object)visitor.toString(), (Object)BINARY_10);
    }

    @Test
    public void testBlobType() {
        BlobType blobType = new BlobType();
        blobType.accept(visitor);
        Assert.assertEquals((String)"BlobType() test failed:\n", (Object)visitor.toString(), (Object)BLOB);
        blobType = new BlobType(L10);
        blobType.accept(visitor);
        Assert.assertEquals((String)"BlobType(L10) test failed:\n", (Object)visitor.toString(), (Object)BLOB_10);
    }

    @Test
    public void testLongRawType() {
        LongRawType lrawType = new LongRawType();
        lrawType.accept(visitor);
        Assert.assertEquals((String)"LongRawType() test failed:\n", (Object)visitor.toString(), (Object)LONG_RAW);
        lrawType = new LongRawType(L10);
        lrawType.accept(visitor);
        Assert.assertEquals((String)"LongRawType(L10) test failed:\n", (Object)visitor.toString(), (Object)LONG_RAW_10);
    }

    @Test
    public void testRawType() {
        RawType rawType = new RawType();
        rawType.accept(visitor);
        Assert.assertEquals((String)"RawType() test failed:\n", (Object)visitor.toString(), (Object)RAW);
        rawType = new RawType(L10);
        rawType.accept(visitor);
        Assert.assertEquals((String)"RawType(L10) test failed:\n", (Object)visitor.toString(), (Object)RAW_10);
    }

    @Test
    public void testCharType() {
        CharType charType = new CharType();
        charType.accept(visitor);
        Assert.assertEquals((String)"CharType() test failed:\n", (Object)visitor.toString(), (Object)CHAR);
        charType = new CharType(L12);
        charType.accept(visitor);
        Assert.assertEquals((String)"CharType(L12) test failed:\n", (Object)visitor.toString(), (Object)CHAR_12);
    }

    @Test
    public void testNCharType() {
        NCharType nCharType = new NCharType();
        nCharType.accept(visitor);
        Assert.assertEquals((String)"NCharType() test failed:\n", (Object)visitor.toString(), (Object)NCHAR);
        nCharType = new NCharType(L12);
        nCharType.accept(visitor);
        Assert.assertEquals((String)"NCharType(L12) test failed:\n", (Object)visitor.toString(), (Object)NCHAR_12);
    }

    @Test
    public void testClobType() {
        ClobType clobType = new ClobType();
        clobType.accept(visitor);
        Assert.assertEquals((String)"ClobType() test failed:\n", (Object)visitor.toString(), (Object)CLOB);
        clobType = new ClobType(L10);
        clobType.accept(visitor);
        Assert.assertEquals((String)"ClobType(L10) test failed:\n", (Object)visitor.toString(), (Object)CLOB_10);
    }

    @Test
    public void testNClobType() {
        NClobType nClobType = new NClobType();
        nClobType.accept(visitor);
        Assert.assertEquals((String)"NClobType() test failed:\n", (Object)visitor.toString(), (Object)NCLOB);
    }

    @Test
    public void testURowIdType() {
        URowIdType uRowIdType = new URowIdType();
        uRowIdType.accept(visitor);
        Assert.assertEquals((String)"URowIdType() test failed:\n", (Object)visitor.toString(), (Object)UROWID);
        uRowIdType = new URowIdType(L4001);
        uRowIdType.accept(visitor);
        Assert.assertEquals((String)"URowIdType(L4001) test failed:\n", (Object)visitor.toString(), (Object)UROWID_4001);
    }

    @Test
    public void testVarCharType() {
        VarCharType varcharType = new VarCharType();
        varcharType.accept(visitor);
        Assert.assertEquals((String)"VarCharType() test failed:\n", (Object)visitor.toString(), (Object)VARCHAR);
        varcharType = new VarCharType(L10);
        varcharType.accept(visitor);
        Assert.assertEquals((String)"VarCharType(L10) test failed:\n", (Object)visitor.toString(), (Object)VARCHAR_10);
    }

    @Test
    public void testVarChar2Type() {
        VarChar2Type varchar2Type = new VarChar2Type();
        varchar2Type.accept(visitor);
        Assert.assertEquals((String)"VarChar2Type() test failed:\n", (Object)visitor.toString(), (Object)VARCHAR2);
        varchar2Type = new VarChar2Type(L10);
        varchar2Type.accept(visitor);
        Assert.assertEquals((String)"VarChar2Type(L10) test failed:\n", (Object)visitor.toString(), (Object)VARCHAR2_10);
    }

    @Test
    public void testLongType() {
        LongType longType = new LongType();
        longType.accept(visitor);
        Assert.assertEquals((String)"LongType() test failed:\n", (Object)visitor.toString(), (Object)LONG);
        longType = new LongType(L10);
        longType.accept(visitor);
        Assert.assertEquals((String)"LongType(L10) test failed:\n", (Object)visitor.toString(), (Object)LONG_10);
    }

    @Test
    public void testNVarChar2Type() {
        NVarChar2Type nVarchar2Type = new NVarChar2Type();
        nVarchar2Type.accept(visitor);
        Assert.assertEquals((String)"NVarChar2Type() test failed:\n", (Object)visitor.toString(), (Object)NVARCHAR2);
        nVarchar2Type = new NVarChar2Type(L10);
        nVarchar2Type.accept(visitor);
        Assert.assertEquals((String)"NVarChar2Type(L10) test failed:\n", (Object)visitor.toString(), (Object)NVARCHAR2_10);
    }
}

