/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.commons;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.Opcodes;
import org.eclipse.persistence.internal.libraries.asm.tree.AbstractInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.InsnList;
import org.eclipse.persistence.internal.libraries.asm.tree.InsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.JumpInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.LabelNode;
import org.eclipse.persistence.internal.libraries.asm.tree.LocalVariableNode;
import org.eclipse.persistence.internal.libraries.asm.tree.LookupSwitchInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.MethodNode;
import org.eclipse.persistence.internal.libraries.asm.tree.TableSwitchInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.TryCatchBlockNode;

public class JSRInlinerAdapter
extends MethodNode
implements Opcodes {
    private static final boolean LOGGING = false;
    private final MethodVisitor mv;
    private final Map subroutineHeads = new HashMap();
    private final Subroutine mainSubroutine = new Subroutine();
    final BitSet dualCitizens = new BitSet();

    public JSRInlinerAdapter(MethodVisitor methodVisitor, int n, String string, String string2, String string3, String[] stringArray) {
        super(n, string, string2, string3, stringArray);
        this.mv = methodVisitor;
    }

    public void visitJumpInsn(int n, Label label) {
        super.visitJumpInsn(n, label);
        LabelNode labelNode = ((JumpInsnNode)this.instructions.getLast()).label;
        if (n == 168 && !this.subroutineHeads.containsKey(labelNode)) {
            this.subroutineHeads.put(labelNode, new Subroutine());
        }
    }

    public void visitEnd() {
        if (!this.subroutineHeads.isEmpty()) {
            this.markSubroutines();
            this.emitCode();
        }
        if (this.mv != null) {
            this.accept(this.mv);
        }
    }

    private void markSubroutines() {
        BitSet bitSet = new BitSet();
        this.markSubroutineWalk(this.mainSubroutine, 0, bitSet);
        for (Map.Entry entry : this.subroutineHeads.entrySet()) {
            LabelNode labelNode = (LabelNode)entry.getKey();
            Subroutine subroutine = (Subroutine)entry.getValue();
            int n = this.instructions.indexOf(labelNode);
            this.markSubroutineWalk(subroutine, n, bitSet);
        }
    }

    private void markSubroutineWalk(Subroutine subroutine, int n, BitSet bitSet) {
        this.markSubroutineWalkDFS(subroutine, n, bitSet);
        boolean bl = true;
        while (bl) {
            bl = false;
            for (TryCatchBlockNode tryCatchBlockNode : this.tryCatchBlocks) {
                int n2 = this.instructions.indexOf(tryCatchBlockNode.handler);
                if (subroutine.instructions.get(n2)) continue;
                int n3 = this.instructions.indexOf(tryCatchBlockNode.start);
                int n4 = this.instructions.indexOf(tryCatchBlockNode.end);
                int n5 = subroutine.instructions.nextSetBit(n3);
                if (n5 == -1 || n5 >= n4) continue;
                this.markSubroutineWalkDFS(subroutine, n2, bitSet);
                bl = true;
            }
        }
    }

    private void markSubroutineWalkDFS(Subroutine subroutine, int n, BitSet bitSet) {
        while (true) {
            LabelNode labelNode;
            int n2;
            int n3;
            AbstractInsnNode abstractInsnNode;
            AbstractInsnNode abstractInsnNode2 = this.instructions.get(n);
            if (subroutine.instructions.get(n)) {
                return;
            }
            subroutine.instructions.set(n);
            if (bitSet.get(n)) {
                this.dualCitizens.set(n);
            }
            bitSet.set(n);
            if (abstractInsnNode2.getType() == 6 && abstractInsnNode2.getOpcode() != 168) {
                abstractInsnNode = (JumpInsnNode)abstractInsnNode2;
                n3 = this.instructions.indexOf(abstractInsnNode.label);
                this.markSubroutineWalkDFS(subroutine, n3, bitSet);
            }
            if (abstractInsnNode2.getType() == 10) {
                abstractInsnNode = (TableSwitchInsnNode)abstractInsnNode2;
                n3 = this.instructions.indexOf(((TableSwitchInsnNode)abstractInsnNode).dflt);
                this.markSubroutineWalkDFS(subroutine, n3, bitSet);
                for (n2 = ((TableSwitchInsnNode)abstractInsnNode).labels.size() - 1; n2 >= 0; --n2) {
                    labelNode = (LabelNode)((TableSwitchInsnNode)abstractInsnNode).labels.get(n2);
                    n3 = this.instructions.indexOf(labelNode);
                    this.markSubroutineWalkDFS(subroutine, n3, bitSet);
                }
            }
            if (abstractInsnNode2.getType() == 11) {
                abstractInsnNode = (LookupSwitchInsnNode)abstractInsnNode2;
                n3 = this.instructions.indexOf(((LookupSwitchInsnNode)abstractInsnNode).dflt);
                this.markSubroutineWalkDFS(subroutine, n3, bitSet);
                for (n2 = ((LookupSwitchInsnNode)abstractInsnNode).labels.size() - 1; n2 >= 0; --n2) {
                    labelNode = (LabelNode)((LookupSwitchInsnNode)abstractInsnNode).labels.get(n2);
                    n3 = this.instructions.indexOf(labelNode);
                    this.markSubroutineWalkDFS(subroutine, n3, bitSet);
                }
            }
            switch (this.instructions.get(n).getOpcode()) {
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
            }
            ++n;
        }
    }

    private void emitCode() {
        LinkedList<Instantiation> linkedList = new LinkedList<Instantiation>();
        linkedList.add(new Instantiation(null, this.mainSubroutine));
        InsnList insnList = new InsnList();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        while (!linkedList.isEmpty()) {
            Instantiation instantiation = (Instantiation)linkedList.removeFirst();
            this.emitSubroutine(instantiation, linkedList, insnList, arrayList, arrayList2);
        }
        this.instructions = insnList;
        this.tryCatchBlocks = arrayList;
        this.localVariables = arrayList2;
    }

    private void emitSubroutine(Instantiation instantiation, List list, InsnList insnList, List list2, List list3) {
        LabelNode labelNode;
        Object object;
        AbstractInsnNode abstractInsnNode;
        Object object2 = null;
        int n = this.instructions.size();
        for (int i = 0; i < n; ++i) {
            Object object3;
            abstractInsnNode = this.instructions.get(i);
            object = instantiation.findOwner(i);
            if (abstractInsnNode.getType() == 7) {
                labelNode = (LabelNode)abstractInsnNode;
                object3 = instantiation.rangeLabel(labelNode);
                if (object3 == object2) continue;
                insnList.add((AbstractInsnNode)object3);
                object2 = object3;
                continue;
            }
            if (object != instantiation) continue;
            if (abstractInsnNode.getOpcode() == 169) {
                labelNode = null;
                object3 = instantiation;
                while (object3 != null) {
                    if (((Instantiation)object3).subroutine.ownsInstruction(i)) {
                        labelNode = ((Instantiation)object3).returnLabel;
                    }
                    object3 = ((Instantiation)object3).previous;
                }
                if (labelNode == null) {
                    throw new RuntimeException("Instruction #" + i + " is a RET not owned by any subroutine");
                }
                insnList.add(new JumpInsnNode(167, labelNode));
                continue;
            }
            if (abstractInsnNode.getOpcode() == 168) {
                labelNode = ((JumpInsnNode)abstractInsnNode).label;
                object3 = (Subroutine)this.subroutineHeads.get(labelNode);
                Instantiation instantiation2 = new Instantiation(instantiation, (Subroutine)object3);
                LabelNode labelNode2 = instantiation2.gotoLabel(labelNode);
                insnList.add(new InsnNode(1));
                insnList.add(new JumpInsnNode(167, labelNode2));
                insnList.add(instantiation2.returnLabel);
                list.add(instantiation2);
                continue;
            }
            insnList.add(abstractInsnNode.clone(instantiation));
        }
        for (TryCatchBlockNode tryCatchBlockNode : this.tryCatchBlocks) {
            abstractInsnNode = instantiation.rangeLabel(tryCatchBlockNode.start);
            if (abstractInsnNode == (object = instantiation.rangeLabel(tryCatchBlockNode.end))) continue;
            labelNode = instantiation.gotoLabel(tryCatchBlockNode.handler);
            if (abstractInsnNode == null || object == null || labelNode == null) {
                throw new RuntimeException("Internal error!");
            }
            list2.add(new TryCatchBlockNode((LabelNode)abstractInsnNode, (LabelNode)object, labelNode, tryCatchBlockNode.type));
        }
        for (LocalVariableNode localVariableNode : this.localVariables) {
            abstractInsnNode = instantiation.rangeLabel(localVariableNode.start);
            if (abstractInsnNode == (object = instantiation.rangeLabel(localVariableNode.end))) continue;
            list3.add(new LocalVariableNode(localVariableNode.name, localVariableNode.desc, localVariableNode.signature, (LabelNode)abstractInsnNode, (LabelNode)object, localVariableNode.index));
        }
    }

    private static void log(String string) {
        System.err.println(string);
    }

    private class Instantiation
    extends AbstractMap {
        final Instantiation previous;
        public final Subroutine subroutine;
        public final Map rangeTable = new HashMap();
        public final LabelNode returnLabel;

        Instantiation(Instantiation instantiation, Subroutine subroutine) {
            this.previous = instantiation;
            this.subroutine = subroutine;
            Object object = instantiation;
            while (object != null) {
                if (((Instantiation)object).subroutine == subroutine) {
                    throw new RuntimeException("Recursive invocation of " + subroutine);
                }
                object = ((Instantiation)object).previous;
            }
            this.returnLabel = instantiation != null ? new LabelNode() : null;
            object = null;
            int n = JSRInlinerAdapter.this.instructions.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode abstractInsnNode = JSRInlinerAdapter.this.instructions.get(i);
                if (abstractInsnNode.getType() == 7) {
                    LabelNode labelNode = (LabelNode)abstractInsnNode;
                    if (object == null) {
                        object = new LabelNode();
                    }
                    this.rangeTable.put(labelNode, object);
                    continue;
                }
                if (this.findOwner(i) != this) continue;
                object = null;
            }
        }

        public Instantiation findOwner(int n) {
            if (!this.subroutine.ownsInstruction(n)) {
                return null;
            }
            if (!JSRInlinerAdapter.this.dualCitizens.get(n)) {
                return this;
            }
            Instantiation instantiation = this;
            Instantiation instantiation2 = this.previous;
            while (instantiation2 != null) {
                if (instantiation2.subroutine.ownsInstruction(n)) {
                    instantiation = instantiation2;
                }
                instantiation2 = instantiation2.previous;
            }
            return instantiation;
        }

        public LabelNode gotoLabel(LabelNode labelNode) {
            Instantiation instantiation = this.findOwner(JSRInlinerAdapter.this.instructions.indexOf(labelNode));
            return (LabelNode)instantiation.rangeTable.get(labelNode);
        }

        public LabelNode rangeLabel(LabelNode labelNode) {
            return (LabelNode)this.rangeTable.get(labelNode);
        }

        public Set entrySet() {
            return null;
        }

        public Object get(Object object) {
            return this.gotoLabel((LabelNode)object);
        }
    }

    protected static class Subroutine {
        public final BitSet instructions = new BitSet();

        protected Subroutine() {
        }

        public void addInstruction(int n) {
            this.instructions.set(n);
        }

        public boolean ownsInstruction(int n) {
            return this.instructions.get(n);
        }

        public String toString() {
            return "Subroutine: " + this.instructions;
        }
    }
}

