/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringLiteral
extends AbstractExpression {
    StringLiteral(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.buildStringExpression(this.getText()));
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return StringLiteral.queryBNF("string_literal");
    }

    @Override
    public String getText() {
        return super.getText();
    }

    public String getUnquotedText() {
        return ExpressionTools.unquote(this.getText());
    }

    public boolean hasCloseQuote() {
        String text = this.getText();
        int length = text.length();
        return length > 1 && ExpressionTools.isQuote(text.charAt(length - 1));
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        String literal = ExpressionTools.parseLiteral(wordParser);
        wordParser.moveForward(literal);
        this.setText(literal);
    }

    @Override
    public String toParsedText() {
        return this.getText();
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        writer.append(this.getText());
    }
}

