/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.io.IOException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;

public class XMLReader
implements org.xml.sax.XMLReader {
    protected static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    public static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    public static final String REPORT_IGNORED_ELEMENT_CONTENT_WHITESPACE_FEATURE = "http://java.sun.com/xml/schema/features/report-ignored-element-content-whitespace";
    private org.xml.sax.XMLReader reader;
    private boolean supportsLexicalHandler = true;
    private LexicalHandlerWrapper lexicalHandlerWrapper;

    public XMLReader(org.xml.sax.XMLReader internalReader) {
        this();
        this.reader = internalReader;
    }

    public XMLReader() {
    }

    public ContentHandler getContentHandler() {
        return this.reader.getContentHandler();
    }

    public void setContentHandler(ContentHandler handler) {
        this.reader.setContentHandler(handler);
    }

    public DTDHandler getDTDHandler() {
        return this.reader.getDTDHandler();
    }

    public void setDTDHandler(DTDHandler handler) {
        this.reader.setDTDHandler(handler);
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.reader.setEntityResolver(resolver);
    }

    public EntityResolver getEntityResolver() {
        return this.reader.getEntityResolver();
    }

    public ErrorHandler getErrorHandler() {
        return this.reader.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.reader.setErrorHandler(handler);
    }

    public LexicalHandler getLexicalHandler() {
        if (this.supportsLexicalHandler) {
            try {
                return (LexicalHandler)this.reader.getProperty(LEXICAL_HANDLER_PROPERTY);
            }
            catch (SAXException e) {
                this.supportsLexicalHandler = false;
            }
        }
        return null;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        if (this.supportsLexicalHandler) {
            if (null == this.lexicalHandlerWrapper) {
                try {
                    this.lexicalHandlerWrapper = new LexicalHandlerWrapper(lexicalHandler);
                    this.reader.setProperty(LEXICAL_HANDLER_PROPERTY, this.lexicalHandlerWrapper);
                }
                catch (SAXException e) {
                    this.supportsLexicalHandler = false;
                }
            } else {
                this.lexicalHandlerWrapper.setLexicalHandler(lexicalHandler);
            }
        }
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.reader.getFeature(name);
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.reader.setFeature(name, value);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (LEXICAL_HANDLER_PROPERTY.equals(name)) {
            return this.getLexicalHandler();
        }
        return this.reader.getProperty(name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (LEXICAL_HANDLER_PROPERTY.equals(name)) {
            this.setLexicalHandler((LexicalHandler)value);
        } else {
            this.reader.setProperty(name, value);
        }
    }

    public void parse(InputSource input) throws IOException, SAXException {
        try {
            this.reader.parse(input);
        }
        catch (SAXNotSupportedException e) {
            String message = e.getMessage();
            if (message != null && message.contains("namespace-prefix")) {
                this.reader.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
                this.reader.parse(input);
            }
            throw e;
        }
    }

    public void parse(String systemId) throws IOException, SAXException {
        try {
            this.reader.parse(systemId);
        }
        catch (SAXNotSupportedException e) {
            String message = e.getMessage();
            if (message != null && message.contains("namespace-prefix")) {
                this.reader.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
                this.reader.parse(systemId);
            }
            throw e;
        }
    }

    public void newObjectEvent(Object object, Object parent, XMLMapping selfRecordMapping) {
    }

    public Object getCurrentObject(AbstractSession session, XMLMapping selfRecordMapping) {
        return null;
    }

    private static class LexicalHandlerWrapper
    implements LexicalHandler {
        private LexicalHandler lexicalHandler;

        public LexicalHandlerWrapper(LexicalHandler lexicalHandler) {
            this.lexicalHandler = lexicalHandler;
        }

        public void setLexicalHandler(LexicalHandler lexicalHandler) {
            this.lexicalHandler = lexicalHandler;
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            if (null != this.lexicalHandler) {
                this.lexicalHandler.comment(ch, start, length);
            }
        }

        public void endCDATA() throws SAXException {
            if (null != this.lexicalHandler) {
                this.lexicalHandler.endCDATA();
            }
        }

        public void endDTD() throws SAXException {
            if (null != this.lexicalHandler) {
                this.lexicalHandler.endDTD();
            }
        }

        public void endEntity(String name) throws SAXException {
            if (null != this.lexicalHandler) {
                this.lexicalHandler.endEntity(name);
            }
        }

        public void startCDATA() throws SAXException {
            if (null != this.lexicalHandler) {
                this.lexicalHandler.startCDATA();
            }
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            if (null != this.lexicalHandler) {
                this.lexicalHandler.startCDATA();
            }
        }

        public void startEntity(String name) throws SAXException {
            if (null != this.lexicalHandler) {
                this.lexicalHandler.startEntity(name);
            }
        }
    }
}

