/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.dynamic;

import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValuesAccessor
extends AttributeAccessor {
    protected static final Object NULL_VALUE = new Object();
    protected DatabaseMapping mapping;
    protected DynamicType type;
    protected int index;

    public ValuesAccessor(DynamicType type, DatabaseMapping mapping, int index) {
        this.type = type;
        this.mapping = mapping;
        this.index = index;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    public int getIndex() {
        return this.index;
    }

    public DynamicType getType() {
        return this.type;
    }

    private Object[] getValues(Object entity) {
        Object[] values = ((DynamicEntityImpl)entity).values;
        if (this.getIndex() >= values.length) {
            Object[] newValues = new Object[this.getType().getNumberOfProperties()];
            System.arraycopy(values, 0, newValues, 0, values.length);
            ((DynamicEntityImpl)entity).values = newValues;
            values = newValues;
        }
        return values;
    }

    public Object getRawValue(Object entity) {
        return this.getValues(entity)[this.getIndex()];
    }

    @Override
    public Object getAttributeValueFromObject(Object entity) throws DescriptorException {
        Object value = this.getRawValue(entity);
        return value == NULL_VALUE ? null : value;
    }

    public void setRawValue(Object entity, Object value) {
        this.getValues((Object)entity)[this.getIndex()] = value;
    }

    @Override
    public void setAttributeValueInObject(Object entity, Object value) throws DescriptorException {
        this.setRawValue(entity, value == null ? NULL_VALUE : value);
    }

    protected boolean isSet(Object entity) throws DescriptorException {
        Object[] values = this.getValues(entity);
        Object value = values[this.getIndex()];
        if (value instanceof IndirectContainer) {
            return ((IndirectContainer)value).isInstantiated();
        }
        if (value instanceof ValueHolderInterface) {
            return ((ValueHolderInterface)value).isInstantiated();
        }
        return value != null || value == NULL_VALUE;
    }

    @Override
    public Class<?> getAttributeClass() {
        if (this.getMapping().isForeignReferenceMapping()) {
            ForeignReferenceMapping refMapping = (ForeignReferenceMapping)this.getMapping();
            if (refMapping.isCollectionMapping()) {
                return ((CollectionMapping)refMapping).getContainerPolicy().getContainerClass();
            }
            if (refMapping.usesIndirection()) {
                return ValueHolderInterface.class;
            }
            return refMapping.getReferenceClass();
        }
        if (this.getMapping().getAttributeClassification() == null) {
            return ClassConstants.OBJECT;
        }
        return this.getMapping().getAttributeClassification();
    }
}

