/*
 * Copyright (C) 2010 Oracle Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.osgi.jpa;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

import javax.persistence.spi.PersistenceProviderResolverHolder;

/**
 * Activator class for OSGi integration
 * 
 * @author mkeith, tware
 */
public class Activator implements BundleActivator {

    private static final String DEPRECATED_ACTIVATOR = "org.eclipse.persistence.javax.persistence.osgi.Activator";
    private BundleActivator deprecatedActivator;
    
    public void start(BundleContext context) throws Exception {
        initializeDeprecatedActivator();
        if (deprecatedActivator != null){
            deprecatedActivator.start(context);
        } else {
            PersistenceProviderResolverHolder
                .setPersistenceProviderResolver(new OSGiProviderResolver(context));
        }
    }
    
    public void stop(BundleContext context) throws Exception {
        if (deprecatedActivator != null){
            deprecatedActivator.stop(context);
        } else {
            PersistenceProviderResolverHolder
                .setPersistenceProviderResolver(null);
        }
    }
    
    private void initializeDeprecatedActivator(){
        try {
            Class activatorClass = this.getClass().getClassLoader().loadClass(DEPRECATED_ACTIVATOR);
            deprecatedActivator = (BundleActivator)activatorClass.newInstance();
        } catch (ClassNotFoundException e){
        } catch (IllegalAccessException e){
        } catch (InstantiationException e){
        }
    }
}
