/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaClassImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelImpl;

public class JavaMethodImpl
implements JavaMethod {
    protected Method jMethod;
    private JavaModelImpl javaModelImpl;

    public JavaMethodImpl(Method javaMethod, JavaModelImpl javaModelImpl) {
        this.jMethod = javaMethod;
        this.javaModelImpl = javaModelImpl;
    }

    public Collection getActualTypeArguments() {
        Type[] params;
        ArrayList<JavaClass> argCollection = new ArrayList<JavaClass>();
        for (Type type : params = this.jMethod.getGenericParameterTypes()) {
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                argCollection.add(new JavaClassImpl(pType, pType.getClass(), this.javaModelImpl));
                continue;
            }
            if (!(type instanceof Class)) continue;
            argCollection.add(this.javaModelImpl.getClass((Class)type));
        }
        return argCollection;
    }

    public JavaAnnotation getAnnotation(JavaClass arg0) {
        Class annotationClass;
        if (arg0 != null && this.jMethod.isAnnotationPresent(annotationClass = ((JavaClassImpl)arg0).getJavaClass())) {
            return new JavaAnnotationImpl((Annotation)this.jMethod.getAnnotation(annotationClass));
        }
        return null;
    }

    public Collection getAnnotations() {
        Annotation[] annotations;
        ArrayList<JavaAnnotationImpl> annotationCollection = new ArrayList<JavaAnnotationImpl>();
        for (Annotation annotation : annotations = this.jMethod.getAnnotations()) {
            annotationCollection.add(new JavaAnnotationImpl(annotation));
        }
        return annotationCollection;
    }

    public String getName() {
        return this.jMethod.getName();
    }

    public JavaClass[] getParameterTypes() {
        Class[] params = PrivilegedAccessHelper.getMethodParameterTypes((Method)this.jMethod);
        JavaClass[] paramArray = new JavaClass[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramArray[i] = this.javaModelImpl.getClass(params[i]);
        }
        return paramArray;
    }

    public JavaClass getResolvedType() {
        Class returnType = PrivilegedAccessHelper.getMethodReturnType((Method)this.jMethod);
        return this.javaModelImpl.getClass(returnType);
    }

    public JavaClass getReturnType() {
        Type type = this.jMethod.getGenericReturnType();
        Class returnType = PrivilegedAccessHelper.getMethodReturnType((Method)this.jMethod);
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return new JavaClassImpl(pType, returnType, this.javaModelImpl);
        }
        return this.javaModelImpl.getClass(returnType);
    }

    public boolean hasActualTypeArguments() {
        Type[] params;
        for (Type type : params = this.jMethod.getGenericParameterTypes()) {
            if (!(type instanceof ParameterizedType)) continue;
            return true;
        }
        return false;
    }

    public int getModifiers() {
        return this.jMethod.getModifiers();
    }

    public JavaClass getOwningClass() {
        return this.javaModelImpl.getClass(this.jMethod.getDeclaringClass());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public boolean isSynthetic() {
        return this.jMethod.isSynthetic();
    }

    public JavaAnnotation getDeclaredAnnotation(JavaClass arg0) {
        return null;
    }

    public Collection getDeclaredAnnotations() {
        return null;
    }
}

