/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.persistence.TemporalType;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataConverter;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;

public class TemporalMetadata
extends MetadataConverter {
    private String m_temporal;

    public TemporalMetadata() {
        super("<temporal>");
    }

    public TemporalMetadata(MetadataAnnotation temporal, MetadataAccessibleObject accessibleObject) {
        super(temporal, accessibleObject);
        this.m_temporal = (String)temporal.getAttribute("value");
    }

    public String getTemporal() {
        return this.m_temporal;
    }

    public static boolean isValidTemporalType(MetadataClass cls) {
        return cls.equals(Date.class) || cls.equals(Calendar.class) || cls.equals(GregorianCalendar.class);
    }

    public void process(DatabaseMapping mapping, MappingAccessor accessor, MetadataClass referenceClass, boolean isForMapKey) {
        if (TemporalMetadata.isValidTemporalType(referenceClass)) {
            if (this.m_temporal.equals(TemporalType.DATE.name())) {
                this.setFieldClassification(mapping, java.sql.Date.class, isForMapKey);
            } else if (this.m_temporal.equals(TemporalType.TIME.name())) {
                this.setFieldClassification(mapping, Time.class, isForMapKey);
            } else {
                this.setFieldClassification(mapping, Timestamp.class, isForMapKey);
            }
        } else {
            throw ValidationException.invalidTypeForTemporalAttribute((String)accessor.getAttributeName(), (Object)referenceClass, (Object)accessor.getJavaClass());
        }
        this.setConverter(mapping, (Converter)new TypeConversionConverter(mapping), isForMapKey);
    }

    public void setTemporal(String temporalType) {
        this.m_temporal = temporalType;
    }
}

