/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.CollectionTable;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.CollectionTableMetadata;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.converters.Converter;

public class BasicCollectionAccessor
extends DirectAccessor {
    private ColumnMetadata m_valueColumn;
    private CollectionTableMetadata m_collectionTable;
    private Enum m_joinFetch;

    public BasicCollectionAccessor() {
        super("<basic-collection>");
    }

    protected BasicCollectionAccessor(String xmlElement) {
        super(xmlElement);
    }

    public BasicCollectionAccessor(Annotation basicCollection, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(basicCollection, accessibleObject, classAccessor);
        Object joinFetch;
        if (basicCollection != null) {
            this.m_valueColumn = new ColumnMetadata((Annotation)MetadataHelper.invokeMethod("valueColumn", basicCollection), accessibleObject, this.getAttributeName());
            this.setFetch((Enum)MetadataHelper.invokeMethod("fetch", basicCollection));
        }
        if (this.isAnnotationPresent(CollectionTable.class)) {
            this.m_collectionTable = new CollectionTableMetadata((Annotation)this.getAnnotation(CollectionTable.class), accessibleObject);
        }
        if ((joinFetch = this.getAnnotation(JoinFetch.class)) != null) {
            this.m_joinFetch = (Enum)MetadataHelper.invokeMethod("value", joinFetch);
        }
    }

    protected CollectionTableMetadata getCollectionTable() {
        return this.m_collectionTable;
    }

    protected ColumnMetadata getColumn(String loggingCtx) {
        return this.m_valueColumn == null ? new ColumnMetadata(this.getAccessibleObject(), this.getAttributeName()) : this.m_valueColumn;
    }

    protected DatabaseField getDatabaseField(DatabaseTable defaultTable, String loggingCtx) {
        DatabaseField field = super.getDatabaseField(defaultTable, loggingCtx);
        if (this.getAccessibleObject().isGenericCollectionType()) {
            field.setType(this.getReferenceClass());
        }
        return field;
    }

    protected String getDefaultCollectionTableName() {
        if (this.m_valueColumn != null && this.m_valueColumn.getTable() != null && !this.m_valueColumn.getTable().equals("")) {
            return this.m_valueColumn.getTable();
        }
        return this.getUpperCaseShortJavaClassName() + "_" + this.getUpperCaseAttributeName();
    }

    public FetchType getDefaultFetchType() {
        return FetchType.LAZY;
    }

    public Enum getJoinFetch() {
        return this.m_joinFetch;
    }

    public String getPrivateOwned() {
        return null;
    }

    public Class getReferenceClass() {
        Class cls = this.getReferenceClassFromGeneric();
        return cls == null ? Void.TYPE : cls;
    }

    public ColumnMetadata getValueColumn() {
        return this.m_valueColumn;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        this.initXMLObject(this.m_valueColumn, accessibleObject);
        this.initXMLObject(this.m_collectionTable, accessibleObject);
        if (this.m_valueColumn != null) {
            this.m_valueColumn.setAttributeName(this.getAttributeName());
        }
    }

    public boolean isBasicCollection() {
        return true;
    }

    protected boolean isValidBasicCollectionType() {
        Class rawClass = this.getRawClass();
        return rawClass.equals(Collection.class) || rawClass.equals(Set.class) || rawClass.equals(List.class);
    }

    public void process() {
        if (!this.isValidBasicCollectionType()) {
            throw ValidationException.invalidTypeForBasicCollectionAttribute((String)this.getAttributeName(), (Class)this.getRawClass(), (Class)this.getJavaClass());
        }
        DirectCollectionMapping mapping = new DirectCollectionMapping();
        this.process(mapping);
        this.setIndirectionPolicy((CollectionMapping)mapping, null, this.usesIndirection());
        mapping.setDirectField(this.getDatabaseField(mapping.getReferenceTable(), "metadata_default_value_column"));
        this.processMappingConverter((DatabaseMapping)mapping);
        this.processProperties((DatabaseMapping)mapping);
    }

    protected void process(DirectCollectionMapping mapping) {
        mapping.setAttributeName(this.getAttributeName());
        this.setAccessorMethods((DatabaseMapping)mapping);
        mapping.setJoinFetch(this.getMappingJoinFetchType(this.m_joinFetch));
        this.processCollectionTable(mapping);
        this.processReturnInsertAndUpdate();
        this.getDescriptor().addMapping((DatabaseMapping)mapping);
    }

    protected void processCollectionTable(DirectCollectionMapping mapping) {
        if (this.m_collectionTable == null) {
            this.m_collectionTable = new CollectionTableMetadata(null, this.getAccessibleObject());
        }
        this.processTable(this.m_collectionTable, this.getDefaultCollectionTableName());
        mapping.setReferenceTable(this.m_collectionTable.getDatabaseTable());
        for (PrimaryKeyJoinColumnMetadata primaryKeyJoinColumn : this.processPrimaryKeyJoinColumns(new PrimaryKeyJoinColumnsMetadata(this.m_collectionTable.getPrimaryKeyJoinColumns()))) {
            DatabaseField pkField = primaryKeyJoinColumn.getPrimaryKeyField();
            pkField.setName(this.getName(pkField, this.getDescriptor().getPrimaryKeyFieldName(), "metadata_default_pk_column"));
            pkField.setTable(this.getDescriptor().getPrimaryTable());
            DatabaseField fkField = primaryKeyJoinColumn.getForeignKeyField();
            fkField.setName(this.getName(fkField, this.getDescriptor().getPrimaryKeyFieldName(), "metadata_default_fk_column"));
            fkField.setTable(this.m_collectionTable.getDatabaseTable());
            mapping.addReferenceKeyField(fkField, pkField);
        }
    }

    protected void setCollectionTable(CollectionTableMetadata collectionTable) {
        this.m_collectionTable = collectionTable;
    }

    public void setConverter(DatabaseMapping mapping, Converter converter) {
        ((DirectCollectionMapping)mapping).setValueConverter(converter);
    }

    public void setConverterClassName(DatabaseMapping mapping, String converterClassName) {
        ((DirectCollectionMapping)mapping).setValueConverterClassName(converterClassName);
    }

    public void setFieldClassification(DatabaseMapping mapping, Class classification) {
        ((DirectCollectionMapping)mapping).setDirectFieldClassification(classification);
    }

    public void setJoinFetch(Enum joinFetch) {
        this.m_joinFetch = joinFetch;
    }

    public void setValueColumn(ColumnMetadata valueColumn) {
        this.m_valueColumn = valueColumn;
    }
}

