/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class WriterRecord
extends MarshalRecord {
    protected Writer writer;
    protected boolean isStartElementOpen = false;
    protected boolean isProcessingCData = false;

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void startDocument(String encoding, String version) {
        try {
            this.writer.write("<?xml version=\"");
            this.writer.write(version);
            this.writer.write("\"");
            if (null != encoding) {
                this.writer.write(" encoding=\"");
                this.writer.write(encoding);
                this.writer.write("\"");
            }
            this.writer.write("?>");
            this.writer.write(Helper.cr());
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void endDocument() {
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        try {
            if (this.isStartElementOpen) {
                this.writer.write(62);
            }
            this.isStartElementOpen = true;
            this.writer.write(60);
            this.writer.write(xPathFragment.getShortName());
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void element(String namespaceURI, String localName, String qName) {
        try {
            if (this.isStartElementOpen) {
                this.writer.write(62);
                this.isStartElementOpen = false;
            }
            this.getWriter().write(60);
            this.getWriter().write(qName);
            this.getWriter().write(47);
            this.getWriter().write(62);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        this.attribute(null, xPathFragment.getLocalName(), xPathFragment.getShortName(), value);
    }

    public void attribute(String namespaceURI, String localName, String qName, String value) {
        try {
            this.writer.write(32);
            this.writer.write(qName);
            this.writer.write(61);
            this.writer.write(34);
            this.writeValue(value);
            this.writer.write(34);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void closeStartElement() {
    }

    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        try {
            if (this.isStartElementOpen) {
                this.writer.write(47);
                this.writer.write(62);
                this.isStartElementOpen = false;
            } else {
                this.writer.write(60);
                this.writer.write(47);
                this.writer.write(xPathFragment.getShortName());
                this.writer.write(62);
            }
            this.isStartElementOpen = false;
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void characters(String value) {
        try {
            if (this.isStartElementOpen) {
                this.isStartElementOpen = false;
                this.writer.write(62);
            }
            this.writeValue(value);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void cdata(String value) {
        try {
            if (this.isStartElementOpen) {
                this.isStartElementOpen = false;
                this.writer.write(62);
            }
            String valueToWrite = "<![CDATA[" + value + "]]>";
            this.writer.write(valueToWrite);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    protected void writeValue(String value) {
        try {
            block7: for (char character : value.toCharArray()) {
                switch (character) {
                    case '&': {
                        this.writer.write("&amp;");
                        continue block7;
                    }
                    case '<': {
                        this.writer.write("&lt;");
                        continue block7;
                    }
                    case '\"': {
                        this.writer.write("&quot;");
                        continue block7;
                    }
                    default: {
                        this.writer.write(character);
                    }
                }
            }
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void node(Node node, NamespaceResolver namespaceResolver) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (namespaceResolver != null) {
                resolverPfx = namespaceResolver.resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", resolverPfx + ":" + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue());
        } else {
            try {
                WriterRecordContentHandler wrcHandler = new WriterRecordContentHandler();
                XMLFragmentReader xfragReader = new XMLFragmentReader(namespaceResolver);
                xfragReader.setContentHandler(wrcHandler);
                xfragReader.setProperty("http://xml.org/sax/properties/lexical-handler", wrcHandler);
                xfragReader.parse(node);
            }
            catch (SAXException sex) {
                throw XMLMarshalException.marshalException(sex);
            }
        }
    }

    protected class WriterRecordContentHandler
    implements ContentHandler,
    LexicalHandler {
        Map<String, String> prefixMappings = new HashMap<String, String>();

        WriterRecordContentHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            try {
                if (WriterRecord.this.isStartElementOpen) {
                    WriterRecord.this.getWriter().write(62);
                }
                WriterRecord.this.getWriter().write(60);
                WriterRecord.this.getWriter().write(qName);
                WriterRecord.this.isStartElementOpen = true;
                this.handleAttributes(atts);
                this.writePrefixMappings();
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            try {
                if (WriterRecord.this.isStartElementOpen) {
                    WriterRecord.this.getWriter().write(47);
                    WriterRecord.this.getWriter().write(62);
                } else {
                    WriterRecord.this.getWriter().write(60);
                    WriterRecord.this.getWriter().write(47);
                    WriterRecord.this.getWriter().write(qName);
                    WriterRecord.this.getWriter().write(62);
                }
                WriterRecord.this.isStartElementOpen = false;
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            String namespaceUri = WriterRecord.this.getNamespaceResolver().resolveNamespacePrefix(prefix);
            if (namespaceUri == null || !namespaceUri.equals(uri)) {
                this.prefixMappings.put(prefix, uri);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (WriterRecord.this.isProcessingCData) {
                WriterRecord.this.cdata(new String(ch, start, length));
                return;
            }
            if (WriterRecord.this.isStartElementOpen) {
                try {
                    WriterRecord.this.getWriter().write(62);
                    WriterRecord.this.isStartElementOpen = false;
                }
                catch (IOException e) {
                    throw XMLMarshalException.marshalException(e);
                }
            }
            WriterRecord.this.writeValue(new String(ch, start, length));
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            try {
                if (WriterRecord.this.isStartElementOpen) {
                    WriterRecord.this.getWriter().write(62);
                    WriterRecord.this.isStartElementOpen = false;
                }
                this.writeComment(ch, start, length);
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void startCDATA() throws SAXException {
            WriterRecord.this.isProcessingCData = true;
        }

        public void endCDATA() throws SAXException {
            WriterRecord.this.isProcessingCData = false;
        }

        protected void writePrefixMappings() {
            try {
                if (!this.prefixMappings.isEmpty()) {
                    for (String prefix : this.prefixMappings.keySet()) {
                        WriterRecord.this.getWriter().write(32);
                        WriterRecord.this.getWriter().write("xmlns");
                        if (!prefix.equals("")) {
                            WriterRecord.this.getWriter().write(":");
                            WriterRecord.this.getWriter().write(prefix);
                        }
                        WriterRecord.this.getWriter().write(61);
                        WriterRecord.this.getWriter().write(34);
                        WriterRecord.this.getWriter().write(this.prefixMappings.get(prefix));
                        WriterRecord.this.getWriter().write(34);
                    }
                    this.prefixMappings.clear();
                }
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        protected void handleAttributes(Attributes atts) {
            for (int i = 0; i < atts.getLength(); ++i) {
                if (atts.getQName(i) != null && (atts.getQName(i).startsWith("xmlns:") || atts.getQName(i).equals("xmlns"))) continue;
                WriterRecord.this.attribute(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getValue(i));
            }
        }

        protected void writeComment(char[] chars, int start, int length) {
            try {
                WriterRecord.this.getWriter().write(60);
                WriterRecord.this.getWriter().write(33);
                WriterRecord.this.getWriter().write(45);
                WriterRecord.this.getWriter().write(45);
                for (int x = start; x < length; ++x) {
                    WriterRecord.this.getWriter().write(chars[x]);
                }
                WriterRecord.this.getWriter().write(45);
                WriterRecord.this.getWriter().write(45);
                WriterRecord.this.getWriter().write(62);
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        protected void writeCharacters(char[] chars, int start, int length) {
            try {
                for (int x = start; x < length; ++x) {
                    WriterRecord.this.getWriter().write(chars[x]);
                }
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        public void endDTD() throws SAXException {
        }
    }
}

