/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.jaxb;

import commonj.sdo.DataObject;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XMLDocument;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.sdo.helper.delegates.SDOXMLHelperDelegate;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBHelperContext;
import org.xml.sax.InputSource;

public class JAXBXMLHelper
extends SDOXMLHelperDelegate {
    public JAXBXMLHelper(HelperContext helperContext) {
        super(helperContext);
    }

    public JAXBXMLHelper(HelperContext helperContext, ClassLoader classLoader) {
        super(helperContext, classLoader);
    }

    public JAXBHelperContext getHelperContext() {
        return (JAXBHelperContext)super.getHelperContext();
    }

    public XMLDocument load(InputSource inputSource, String locationURI, Object options) throws IOException {
        if (null == inputSource) {
            return super.load(inputSource, locationURI, options);
        }
        try {
            XMLRoot xmlRoot = (XMLRoot)this.createXMLUnmarshaller().unmarshal(inputSource);
            return this.wrap(xmlRoot);
        }
        catch (XMLMarshalException xmlMarshalException) {
            return this.handleLoadException(xmlMarshalException);
        }
    }

    public XMLDocument load(InputStream inputStream, String locationURI, Object options) throws IOException {
        if (null == inputStream) {
            return super.load(inputStream, locationURI, options);
        }
        return this.load(inputStream);
    }

    public XMLDocument load(InputStream inputStream) throws IOException {
        if (null == inputStream) {
            return super.load(inputStream);
        }
        try {
            XMLRoot xmlRoot = (XMLRoot)this.createXMLUnmarshaller().unmarshal(inputStream);
            return this.wrap(xmlRoot);
        }
        catch (XMLMarshalException xmlMarshalException) {
            return this.handleLoadException(xmlMarshalException);
        }
    }

    public XMLDocument load(Reader inputReader, String locationURI, Object options) throws IOException {
        if (null == inputReader) {
            return super.load(inputReader, locationURI, options);
        }
        try {
            XMLRoot xmlRoot = (XMLRoot)this.createXMLUnmarshaller().unmarshal(inputReader);
            return this.wrap(xmlRoot);
        }
        catch (XMLMarshalException xmlMarshalException) {
            return this.handleLoadException(xmlMarshalException);
        }
    }

    public XMLDocument load(Source source, String locationURI, Object options) throws IOException {
        if (null == source) {
            return super.load(source, locationURI, options);
        }
        try {
            XMLRoot xmlRoot = (XMLRoot)this.createXMLUnmarshaller().unmarshal(source);
            return this.wrap(xmlRoot);
        }
        catch (XMLMarshalException xmlMarshalException) {
            return this.handleLoadException(xmlMarshalException);
        }
    }

    public XMLDocument load(String inputString) {
        if (null == inputString) {
            return super.load(inputString);
        }
        try {
            StringReader reader = new StringReader(inputString);
            return this.load(reader, null, null);
        }
        catch (IOException e) {
            return null;
        }
    }

    private XMLUnmarshaller createXMLUnmarshaller() {
        try {
            JAXBUnmarshaller unmarshaller = (JAXBUnmarshaller)this.getHelperContext().getJAXBContext().createUnmarshaller();
            XMLUnmarshaller xmlUnmarshaller = unmarshaller.getXMLUnmarshaller();
            xmlUnmarshaller.setResultAlwaysXMLRoot(true);
            return xmlUnmarshaller;
        }
        catch (JAXBException e) {
            throw SDOException.sdoJaxbErrorCreatingJAXBUnmarshaller((Exception)((Object)e));
        }
    }

    private XMLDocument wrap(XMLRoot xmlRoot) {
        DataObject dataObject = this.getHelperContext().wrap(xmlRoot.getObject());
        XMLDocument xmlDocument = this.getHelperContext().getXMLHelper().createDocument(dataObject, xmlRoot.getNamespaceURI(), xmlRoot.getLocalName());
        xmlDocument.setEncoding(xmlRoot.getEncoding());
        xmlDocument.setXMLVersion(xmlRoot.getXMLVersion());
        xmlDocument.setSchemaLocation(xmlRoot.getSchemaLocation());
        xmlDocument.setNoNamespaceSchemaLocation(xmlRoot.getNoNamespaceSchemaLocation());
        return xmlDocument;
    }

    private XMLDocument handleLoadException(XMLMarshalException xmlMarshalException) throws IOException {
        if (xmlMarshalException.getCause() instanceof IOException) {
            throw (IOException)xmlMarshalException.getCause();
        }
        throw xmlMarshalException;
    }
}

