/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.equinox.weaving;

import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.persistence.jpa.equinox.weaving.IWeaver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class WeaverRegistry
implements ClassLoadingHook,
ServiceTrackerCustomizer {
    private static WeaverRegistry instance = new WeaverRegistry();
    private List weaverServices = new ArrayList();
    private BundleContext ctx;
    private ServiceTracker serviceTracker;

    private WeaverRegistry() {
    }

    public static WeaverRegistry getInstance() {
        return instance;
    }

    public boolean addClassPathEntry(ArrayList cpEntries, String cp, ClasspathManager hostmanager, BaseData sourcedata, ProtectionDomain sourcedomain) {
        return false;
    }

    public BaseClassLoader createClassLoader(ClassLoader parent, ClassLoaderDelegate delegate, BundleProtectionDomain domain, BaseData data, String[] bundleclasspath) {
        return null;
    }

    public String findLibrary(BaseData data, String libName) {
        return null;
    }

    public ClassLoader getBundleClassLoaderParent() {
        return null;
    }

    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData data) {
    }

    public byte[] processClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        if (this.weaverServices.isEmpty()) {
            return null;
        }
        for (ServiceReference reference : this.weaverServices) {
            byte[] transformedBytes;
            IWeaver weaver = (IWeaver)this.ctx.getService(reference);
            if (weaver == null || (transformedBytes = weaver.transform(name, classbytes)) == null) continue;
            System.out.println(name + " woven");
            return transformedBytes;
        }
        return null;
    }

    public void start(BundleContext context) {
        this.ctx = context;
        this.serviceTracker = new ServiceTracker(context, IWeaver.class.getName(), (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
    }

    public void stop(BundleContext context) {
        this.serviceTracker.close();
        this.serviceTracker = null;
        this.weaverServices = new ArrayList();
    }

    public Object addingService(ServiceReference reference) {
        System.out.println("Registering Service " + reference);
        this.weaverServices.add(reference);
        return reference;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.removedService(reference, service);
    }

    public void removedService(ServiceReference reference, Object service) {
        this.weaverServices.remove(reference);
    }
}

