/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.weaving;

import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.CodeAdapter;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Constants;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.weaving.AttributeDetails;
import org.eclipse.persistence.internal.weaving.ClassWeaver;

public class MethodWeaver
extends CodeAdapter
implements Constants {
    protected ClassWeaver tcw;
    protected String methodName;
    protected String methodDescriptor = null;
    protected boolean methodStarted = false;

    public MethodWeaver(ClassWeaver tcw, String methodName, String methodDescriptor, CodeVisitor cv) {
        super(cv);
        this.tcw = tcw;
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
    }

    public void visitInsn(int opcode) {
        this.weaveBeginningOfMethodIfRequired();
        if (opcode == 177) {
            this.weaveEndOfMethodIfRequired();
        }
        super.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int var) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitVarInsn(opcode, var);
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitTypeInsn(opcode, desc);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.weaveBeginningOfMethodIfRequired();
        this.weaveAttributesIfRequired(opcode, owner, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.weaveBeginningOfMethodIfRequired();
        String descClassName = "";
        if (desc.length() > 3) {
            descClassName = desc.substring(3, desc.length() - 1);
        }
        if (this.tcw.classDetails.shouldWeaveInternal() && name.equals("clone") && this.tcw.classDetails.isInSuperclassHierarchy(owner) && this.tcw.classDetails.isInMetadataHierarchy(descClassName) && this.tcw.classDetails.getNameOfSuperclassImplementingCloneMethod() == null) {
            super.visitMethodInsn(opcode, owner, name, desc);
            super.visitTypeInsn(192, this.tcw.classDetails.getClassName());
            super.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_post_clone", "()Ljava/lang/Object;");
        } else {
            super.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitJumpInsn(opcode, label);
    }

    public void visitLabel(Label label) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitLabel(label);
    }

    public void visitLdcInsn(Object cst) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitLdcInsn(cst);
    }

    public void visitIincInsn(int var, int increment) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitIincInsn(var, increment);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitMaxs(0, 0);
    }

    public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitLocalVariable(name, desc, start, end, index);
    }

    public void visitLineNumber(int line, Label start) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitLineNumber(line, start);
    }

    public void visitAttribute(Attribute attr) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitAttribute(attr);
    }

    public void weaveAttributesIfRequired(int opcode, String owner, String name, String desc) {
        AttributeDetails attributeDetails = this.tcw.classDetails.getAttributeDetailsFromClassOrSuperClass(name);
        if (attributeDetails == null || !attributeDetails.hasField() || !this.tcw.classDetails.isInMetadataHierarchy(owner)) {
            super.visitFieldInsn(opcode, owner, name, desc);
            return;
        }
        if (opcode == 180) {
            if (attributeDetails.weaveValueHolders() || this.tcw.classDetails.shouldWeaveFetchGroups()) {
                this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_get" + name, "()" + attributeDetails.getReferenceClassType().getDescriptor());
            } else {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        } else if (opcode == 181) {
            if (attributeDetails.weaveValueHolders() || this.tcw.classDetails.shouldWeaveChangeTracking() || this.tcw.classDetails.shouldWeaveFetchGroups()) {
                this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_set" + name, "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V");
            } else {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        } else {
            super.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    public void weaveBeginningOfMethodIfRequired() {
        boolean isGetMethod;
        if (this.methodStarted) {
            return;
        }
        this.methodStarted = true;
        AttributeDetails attributeDetails = (AttributeDetails)this.tcw.classDetails.getGetterMethodToAttributeDetails().get(this.methodName);
        boolean bl = isGetMethod = attributeDetails != null && this.methodDescriptor.startsWith("()");
        if (isGetMethod && !attributeDetails.hasField()) {
            if (this.tcw.classDetails.shouldWeaveFetchGroups()) {
                this.cv.visitVarInsn(25, 0);
                this.cv.visitLdcInsn((Object)attributeDetails.getAttributeName());
                this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_checkFetched", "(Ljava/lang/String;)V");
            }
            if (attributeDetails.weaveValueHolders()) {
                this.cv.visitVarInsn(25, 0);
                this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_initialize_" + attributeDetails.getAttributeName() + "_vh", "()V");
                this.cv.visitVarInsn(25, 0);
                this.cv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_persistence_" + attributeDetails.getAttributeName() + "_vh", "Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;");
                this.cv.visitMethodInsn(185, "org/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface", "isInstantiated", "()Z");
                Label l0 = new Label();
                this.cv.visitJumpInsn(154, l0);
                if (this.tcw.classDetails.shouldWeaveChangeTracking()) {
                    this.cv.visitVarInsn(25, 0);
                    this.cv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_persistence_listener", "Ljava/beans/PropertyChangeListener;");
                    this.cv.visitVarInsn(58, 4);
                    this.cv.visitVarInsn(25, 0);
                    this.cv.visitInsn(1);
                    this.cv.visitFieldInsn(181, this.tcw.classDetails.getClassName(), "_persistence_listener", "Ljava/beans/PropertyChangeListener;");
                }
                this.cv.visitVarInsn(25, 0);
                this.cv.visitVarInsn(25, 0);
                this.cv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_persistence_" + attributeDetails.getAttributeName() + "_vh", "Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;");
                this.cv.visitMethodInsn(185, "org/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface", "getValue", "()Ljava/lang/Object;");
                this.cv.visitTypeInsn(192, attributeDetails.getReferenceClassName().replace('.', '/'));
                this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), attributeDetails.getSetterMethodName(), "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V");
                if (this.tcw.classDetails.shouldWeaveChangeTracking()) {
                    this.cv.visitVarInsn(25, 0);
                    this.cv.visitVarInsn(25, 4);
                    this.cv.visitFieldInsn(181, this.tcw.classDetails.getClassName(), "_persistence_listener", "Ljava/beans/PropertyChangeListener;");
                }
                this.cv.visitLabel(l0);
            }
        } else {
            boolean isSetMethod;
            attributeDetails = (AttributeDetails)this.tcw.classDetails.getSetterMethodToAttributeDetails().get(this.methodName);
            boolean bl2 = isSetMethod = attributeDetails != null && this.methodDescriptor.equals(attributeDetails.getSetterMethodSignature());
            if (isSetMethod && !attributeDetails.hasField() && this.tcw.classDetails.shouldWeaveChangeTracking()) {
                String wrapper = ClassWeaver.wrapperFor(attributeDetails.getReferenceClassType().getSort());
                if (wrapper != null) {
                    this.cv.visitTypeInsn(187, wrapper);
                    this.cv.visitInsn(89);
                }
                this.cv.visitVarInsn(25, 0);
                this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), attributeDetails.getGetterMethodName(), "()" + attributeDetails.getReferenceClassType().getDescriptor());
                if (wrapper != null) {
                    this.cv.visitMethodInsn(183, wrapper, "<init>", "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V");
                    this.cv.visitVarInsn(58, 3);
                } else {
                    this.cv.visitVarInsn(58, 2);
                }
            }
        }
    }

    public void weaveEndOfMethodIfRequired() {
        boolean isSetMethod;
        AttributeDetails attributeDetails = (AttributeDetails)this.tcw.classDetails.getSetterMethodToAttributeDetails().get(this.methodName);
        boolean bl = isSetMethod = attributeDetails != null && this.methodDescriptor.equals(attributeDetails.getSetterMethodSignature());
        if (isSetMethod && !attributeDetails.hasField()) {
            if (attributeDetails.weaveValueHolders()) {
                if (this.tcw.classDetails.shouldWeaveChangeTracking()) {
                    this.cv.visitVarInsn(25, 0);
                    this.cv.visitLdcInsn((Object)attributeDetails.getAttributeName());
                    this.cv.visitVarInsn(25, 2);
                    this.cv.visitVarInsn(25, 1);
                    this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_propertyChange", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V");
                }
                this.cv.visitVarInsn(25, 0);
                this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_initialize_" + attributeDetails.getAttributeName() + "_vh", "()V");
                this.cv.visitVarInsn(25, 0);
                this.cv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_persistence_" + attributeDetails.getAttributeName() + "_vh", "Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;");
                this.cv.visitVarInsn(25, 1);
                this.cv.visitMethodInsn(185, "org/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface", "setValue", "(Ljava/lang/Object;)V");
                this.cv.visitVarInsn(25, 0);
                this.cv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_persistence_" + attributeDetails.getAttributeName() + "_vh", "Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;");
                this.cv.visitInsn(4);
                this.cv.visitMethodInsn(185, "org/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface", "setIsCoordinatedWithProperty", "(Z)V");
            } else if (this.tcw.classDetails.shouldWeaveChangeTracking()) {
                this.cv.visitVarInsn(25, 0);
                this.cv.visitLdcInsn((Object)attributeDetails.getAttributeName());
                String wrapper = ClassWeaver.wrapperFor(attributeDetails.getReferenceClassType().getSort());
                int opcode = attributeDetails.getReferenceClassType().getOpcode(21);
                if (wrapper != null) {
                    this.cv.visitVarInsn(25, 3);
                    this.cv.visitTypeInsn(187, wrapper);
                    this.cv.visitInsn(89);
                } else {
                    this.cv.visitVarInsn(25, 2);
                }
                this.cv.visitVarInsn(opcode, 1);
                if (wrapper != null) {
                    this.cv.visitMethodInsn(183, wrapper, "<init>", "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V");
                }
                this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_propertyChange", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V");
            }
        }
    }
}

