/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;

public class ContainerIndirectionPolicy
extends BasicIndirectionPolicy {
    private Class containerClass;
    private String containerClassName;
    private Constructor containerConstructor;

    public Object backupCloneAttribute(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        IndirectContainer container = (IndirectContainer)attributeValue;
        ValueHolderInterface valueHolder = container.getValueHolder();
        ValueHolderInterface newValueHolder = (ValueHolderInterface)super.backupCloneAttribute(valueHolder, clone, backup, unitOfWork);
        return this.buildContainer(newValueHolder);
    }

    protected IndirectContainer buildContainer(ValueHolderInterface valueHolder) {
        try {
            IndirectContainer container = null;
            if (this.getContainerConstructor().getParameterTypes().length == 0) {
                container = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (IndirectContainer)AccessController.doPrivileged(new PrivilegedInvokeConstructor(this.getContainerConstructor(), new Object[0])) : (IndirectContainer)PrivilegedAccessHelper.invokeConstructor(this.getContainerConstructor(), new Object[0]);
                container.setValueHolder(valueHolder);
            } else {
                container = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (IndirectContainer)AccessController.doPrivileged(new PrivilegedInvokeConstructor(this.getContainerConstructor(), new Object[]{valueHolder})) : (IndirectContainer)PrivilegedAccessHelper.invokeConstructor(this.getContainerConstructor(), new Object[]{valueHolder});
            }
            return container;
        }
        catch (Exception exception) {
            throw DescriptorException.invalidIndirectionPolicyOperation(this, "buildContainer constructor (" + this.getContainerConstructor() + ") Failed: " + exception);
        }
    }

    public Object buildIndirectObject(ValueHolderInterface valueHolder) {
        return this.buildContainer(valueHolder);
    }

    public Object cloneAttribute(Object attributeValue, Object original, Object clone, UnitOfWorkImpl unitOfWork, boolean buildDirectlyFromRow) {
        IndirectContainer container = (IndirectContainer)attributeValue;
        ValueHolderInterface valueHolder = container.getValueHolder();
        ValueHolderInterface newValueHolder = (ValueHolderInterface)super.cloneAttribute(valueHolder, original, clone, unitOfWork, buildDirectlyFromRow);
        return this.buildContainer(newValueHolder);
    }

    public AbstractRecord extractReferenceRow(Object referenceObject) {
        if (this.objectIsInstantiated(referenceObject)) {
            return null;
        }
        return ((DatabaseValueHolder)((IndirectContainer)referenceObject).getValueHolder()).getRow();
    }

    public Class getContainerClass() {
        return this.containerClass;
    }

    public String getContainerClassName() {
        if (this.containerClassName == null && this.containerClass != null) {
            this.containerClassName = this.containerClass.getName();
        }
        return this.containerClassName;
    }

    protected Constructor getContainerConstructor() {
        return this.containerConstructor;
    }

    public Object getOriginalIndirectionObject(Object unitOfWorkIndirectionObject, AbstractSession session) {
        IndirectContainer container = (IndirectContainer)unitOfWorkIndirectionObject;
        if (container.getValueHolder() instanceof UnitOfWorkValueHolder) {
            ValueHolderInterface valueHolder = ((UnitOfWorkValueHolder)container.getValueHolder()).getWrappedValueHolder();
            if (valueHolder == null && session.isRemoteUnitOfWork()) {
                RemoteSessionController controller = ((RemoteUnitOfWork)session).getParentSessionController();
                valueHolder = (ValueHolderInterface)controller.getRemoteValueHolders().get(((UnitOfWorkValueHolder)container.getValueHolder()).getWrappedValueHolderRemoteID());
            }
            return this.buildContainer(valueHolder);
        }
        return container;
    }

    public Object getRealAttributeValueFromObject(Object object, Object attribute) {
        return ((IndirectContainer)attribute).getValueHolder().getValue();
    }

    public void initialize() {
        if (!ClassConstants.IndirectContainer_Class.isAssignableFrom(this.containerClass)) {
            throw DescriptorException.invalidIndirectionContainerClass(this, this.containerClass);
        }
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    this.containerConstructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(this.getContainerClass(), new Class[]{ClassConstants.ValueHolderInterface_Class}, false));
                }
                catch (PrivilegedActionException ex) {
                    if (ex.getCause() instanceof NoSuchMethodException) {
                        throw (NoSuchMethodException)ex.getCause();
                    }
                    throw (RuntimeException)ex.getCause();
                }
            } else {
                this.containerConstructor = PrivilegedAccessHelper.getConstructorFor(this.getContainerClass(), new Class[]{ClassConstants.ValueHolderInterface_Class}, false);
            }
            return;
        }
        catch (NoSuchMethodException nsme) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.containerConstructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(this.getContainerClass(), new Class[0], false));
                    }
                    catch (PrivilegedActionException ex) {
                        if (ex.getCause() instanceof NoSuchMethodException) {
                            throw (NoSuchMethodException)ex.getCause();
                        }
                        throw (RuntimeException)ex.getCause();
                    }
                } else {
                    this.containerConstructor = PrivilegedAccessHelper.getConstructorFor(this.getContainerClass(), new Class[0], false);
                }
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw DescriptorException.noConstructorIndirectionContainerClass(this, this.containerClass);
            }
        }
    }

    public void iterateOnAttributeValue(DescriptorIterator iterator, Object attributeValue) {
        super.iterateOnAttributeValue(iterator, ((IndirectContainer)attributeValue).getValueHolder());
    }

    public Object nullValueFromRow() {
        return this.buildContainer(new ValueHolder());
    }

    public void reset(Object target) {
        this.getMapping().setAttributeValueInObject(target, this.buildContainer(new ValueHolder()));
    }

    public boolean objectIsInstantiated(Object object) {
        return ((IndirectContainer)object).getValueHolder().isInstantiated();
    }

    public void setContainerClass(Class containerClass) {
        this.containerClass = containerClass;
    }

    public void setContainterClassName(String containerClassName) {
        this.containerClassName = containerClassName;
    }

    public void setRealAttributeValueInObject(Object target, Object attributeValue) {
        IndirectContainer container = (IndirectContainer)this.getMapping().getAttributeValueFromObject(target);
        container.getValueHolder().setValue(attributeValue);
        this.getMapping().setAttributeValueInObject(target, container);
    }

    protected boolean typeIsValid(Class attributeType) {
        return ClassConstants.IndirectContainer_Class.isAssignableFrom(attributeType) || attributeType.isAssignableFrom(this.getContainerClass());
    }

    public Object validateAttributeOfInstantiatedObject(Object attributeValue) {
        if (!this.getContainerClass().isInstance(attributeValue)) {
            throw DescriptorException.valueHolderInstantiationMismatch(attributeValue, this.getMapping());
        }
        return attributeValue;
    }

    public Object valueFromBatchQuery(ReadQuery batchQuery, AbstractRecord row, ObjectLevelReadQuery originalQuery) {
        ValueHolderInterface valueHolder = (ValueHolderInterface)super.valueFromBatchQuery(batchQuery, row, originalQuery);
        return this.buildContainer(valueHolder);
    }

    public Object valueFromMethod(Object object, AbstractRecord row, AbstractSession session) {
        ValueHolderInterface valueHolder = (ValueHolderInterface)super.valueFromMethod(object, row, session);
        return this.buildContainer(valueHolder);
    }

    public Object valueFromQuery(ReadQuery query, AbstractRecord row, AbstractSession session) {
        ValueHolderInterface valueHolder = (ValueHolderInterface)super.valueFromQuery(query, row, session);
        return this.buildContainer(valueHolder);
    }

    public Object valueFromRow(Object object) {
        return this.buildContainer(new ValueHolder(object));
    }
}

