/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import junit.framework.Test;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.models.inheritance.InheritanceSystem;
import org.eclipse.persistence.testing.models.insurance.InsuranceSystem;
import org.eclipse.persistence.testing.models.mapping.MappingSystem;
import org.eclipse.persistence.testing.models.ownership.OwnershipSystem;
import org.eclipse.persistence.testing.models.transparentindirection.IndirectListSystem;
import org.eclipse.persistence.testing.tests.unitofwork.UOWSystem;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkRollbackConnectionReleaseTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkTestSuite;

public class UnitOfWorkClientSessionTestModel
extends TestModel {
    public Session originalSession;

    public void addRequiredSystems() {
        if (this.getSession().getPlatform().isH2()) {
            throw new TestWarningException("H2 has locking issue with multiple connections");
        }
        this.addRequiredSystem(new OwnershipSystem());
        this.addRequiredSystem(new IndirectListSystem());
        this.addRequiredSystem(new EmployeeSystem());
        this.addRequiredSystem(new InsuranceSystem());
        this.addRequiredSystem(new MappingSystem());
        this.addRequiredSystem(new UOWSystem());
        this.addRequiredSystem(new InheritanceSystem());
    }

    public void addTests() {
        this.addTest((Test)new UnitOfWorkTestSuite());
        this.addTest((Test)new UnitOfWorkRollbackConnectionReleaseTest());
    }

    public Server buildServerSession() {
        Server server = this.getSession().getProject().clone().createServerSession(1, 1);
        server.useReadConnectionPool(1, 1);
        server.setSessionLog(this.getSession().getSessionLog());
        server.login();
        return server;
    }

    public void reset() {
        if (this.originalSession != null) {
            ((ClientSession)this.getSession()).getParent().logout();
            this.getExecutor().setSession(this.originalSession);
        }
    }

    public void setup() {
        this.originalSession = this.getSession();
        ClientSession client = this.buildServerSession().acquireClientSession();
        client.setSessionLog(this.originalSession.getSessionLog());
        this.getExecutor().setSession((Session)client);
    }
}

