/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class LockFailureUnitOfWorkTest
extends AutoVerifyTestCase {
    protected void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void test() {
        UnitOfWork firstUOW = this.getSession().acquireUnitOfWork();
        Employee employee = (Employee)firstUOW.readAllObjects(Employee.class).firstElement();
        String lastName = employee.getLastName();
        boolean isMale = employee.getGender().equals("Male");
        if (isMale) {
            employee.setFemale();
        } else {
            employee.setMale();
        }
        firstUOW.executeNonSelectingCall((Call)new SQLCall("UPDATE EMPLOYEE SET VERSION = VERSION + 66 WHERE L_NAME = '" + lastName + "'"));
        try {
            firstUOW.commitAndResumeOnFailure();
        }
        catch (OptimisticLockException exception) {
            firstUOW.refreshObject((Object)employee);
            if (isMale != employee.getGender().equals("Male")) {
                throw new TestErrorException("Refresh does not work in unit of work.");
            }
            if (isMale) {
                employee.setFemale();
            } else {
                employee.setMale();
            }
            firstUOW.commit();
        }
        UnitOfWork secondUOW = this.getSession().acquireUnitOfWork();
        Employee sameEmployee = (Employee)secondUOW.readObject((Object)employee);
        if (sameEmployee.getGender().equals("Male")) {
            sameEmployee.setFemale();
        } else {
            sameEmployee.setMale();
        }
        secondUOW.commit();
    }
}

