/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.math.BigDecimal;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentAddress;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentPerson;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentReadOnInsertTest;

public class ConcurrentReadOnUpdateWithEarlyTransTest
extends TestCase {
    public static ConcurrentAddress readAddress;
    public ConcurrentAddress originalReference;
    public ConcurrentAddress readObject;
    public static int whosWaiting;
    public static final int READER = 2;
    public static final int WRITER = 1;
    public static ThreadLocal threadId;

    public void setup() {
        if (this.getSession().isDistributedSession()) {
            throw new TestWarningException("Test unavailable on Remote UnitOfWork.");
        }
        readAddress = new ConcurrentAddress();
        readAddress.setId(new BigDecimal(8));
        readAddress.setCity("Toronto");
        readAddress.setPostalCode("L5J2B5");
        readAddress.setProvince("ONT");
        readAddress.setStreet("1450 Acme Cr., suite 4");
        readAddress.setCountry("Canada");
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)readAddress);
        uow.commit();
        ConcurrentAddress.RUNNING_TEST = 57;
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        ConcurrentPerson person = (ConcurrentPerson)uow.readObject(ConcurrentPerson.class);
        this.originalReference = person.getAddress();
        uow.beginEarlyTransaction();
        ConcurrentAddress addressClone = (ConcurrentAddress)uow.readObject((Object)readAddress);
        person.setAddress(addressClone);
        Thread loadThread = new Thread(this.runnable());
        loadThread.start();
        threadId.set("Writer");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        uow.commit();
        try {
            loadThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Runnable runnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                threadId.set("Reader");
                ConcurrentAddress concurrentAddress = readAddress;
                synchronized (concurrentAddress) {
                    whosWaiting = 2;
                    try {
                        readAddress.wait(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ConcurrentReadOnUpdateWithEarlyTransTest.this.readObject = (ConcurrentAddress)ConcurrentReadOnUpdateWithEarlyTransTest.this.getSession().readObject((Object)readAddress);
                concurrentAddress = readAddress;
                synchronized (concurrentAddress) {
                    readAddress.notifyAll();
                }
            }
        };
    }

    public void verify() {
        ConcurrentPerson person = (ConcurrentPerson)this.getSession().readObject(ConcurrentPerson.class);
        if (person.getAddress() != this.readObject) {
            throw new TestErrorException("Object Identity Lost during merge");
        }
    }

    public void reset() {
        ConcurrentAddress.RUNNING_TEST = Integer.MIN_VALUE;
        try {
            UnitOfWork unitOfWork = this.getSession().acquireUnitOfWork();
            ((ConcurrentPerson)unitOfWork.readObject(ConcurrentPerson.class)).setAddress((ConcurrentAddress)unitOfWork.registerObject((Object)this.originalReference));
            unitOfWork.deleteObject((Object)readAddress);
            unitOfWork.commit();
        }
        finally {
            ConcurrentReadOnInsertTest.readAddress = null;
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    static {
        threadId = new ThreadLocal();
    }
}

