/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.nosql.adapters.sdk;

import jakarta.resource.cci.ConnectionSpec;
import java.util.Arrays;
import java.util.Optional;

public class OracleNoSQLJCAConnectionSpec
implements ConnectionSpec {
    private ServiceType service = ServiceType.CLOUD_SIMULATOR;
    private String endPoint;
    private AuthPrincipalType authPrincipalType;
    private String compartment = null;

    public ServiceType getService() {
        return this.service;
    }

    public void setService(ServiceType service) {
        this.service = service;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public AuthPrincipalType getAuthPrincipalType() {
        return this.authPrincipalType;
    }

    public void setAuthPrincipalType(AuthPrincipalType authPrincipalType) {
        this.authPrincipalType = authPrincipalType;
    }

    public String getCompartment() {
        return this.compartment;
    }

    public void setCompartment(String compartment) {
        this.compartment = compartment;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.service + ", " + this.endPoint + ")";
    }

    public static enum ServiceType {
        CLOUD("cloud"),
        ON_PREMISE("onpremise"),
        CLOUD_SIMULATOR("cloudsim");

        private final String serviceName;

        private ServiceType(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public static Optional<ServiceType> get(String serviceName) {
            return Arrays.stream(ServiceType.values()).filter(service -> service.serviceName.equals(serviceName)).findFirst();
        }
    }

    public static enum AuthPrincipalType {
        USER("user"),
        INSTANCE("instance"),
        RESOURCE("resource");

        private final String authPrincipalName;

        private AuthPrincipalType(String authPrincipalName) {
            this.authPrincipalName = authPrincipalName;
        }

        public String getAuthPrincipalName() {
            return this.authPrincipalName;
        }

        public static Optional<AuthPrincipalType> get(String authPrincipalName) {
            return Arrays.stream(AuthPrincipalType.values()).filter(authPrincipalType -> authPrincipalType.authPrincipalName.equals(authPrincipalName)).findFirst();
        }
    }
}

