/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.eis.adapters.aq;

import jakarta.resource.ResourceException;
import jakarta.resource.cci.Connection;
import jakarta.resource.cci.ConnectionMetaData;
import jakarta.resource.cci.Interaction;
import jakarta.resource.cci.LocalTransaction;
import jakarta.resource.cci.ResultSetInfo;
import oracle.jakarta.AQ.AQSession;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.eis.adapters.aq.AQConnectionMetaData;
import org.eclipse.persistence.internal.eis.adapters.aq.AQConnectionSpec;
import org.eclipse.persistence.internal.eis.adapters.aq.AQInteraction;
import org.eclipse.persistence.internal.eis.adapters.aq.AQTransaction;

public class AQConnection
implements Connection {
    protected AQConnectionSpec spec;
    protected AQTransaction transaction;
    protected AQSession session;
    protected java.sql.Connection databaseConnection;

    public AQConnection(AQSession session, java.sql.Connection connection, AQConnectionSpec spec) {
        this.session = session;
        this.databaseConnection = connection;
        this.transaction = new AQTransaction(this);
        this.spec = spec;
    }

    public java.sql.Connection getDatabaseConnection() {
        return this.databaseConnection;
    }

    public AQSession getSession() {
        return this.session;
    }

    public void close() throws ResourceException {
        try {
            this.getSession().close();
            this.getDatabaseConnection().close();
        }
        catch (Exception exception) {
            throw new ResourceException(exception.toString());
        }
    }

    public Interaction createInteraction() {
        return new AQInteraction(this);
    }

    public AQConnectionSpec getConnectionSpec() {
        return this.spec;
    }

    public LocalTransaction getLocalTransaction() {
        return this.transaction;
    }

    public AQTransaction getAQTransaction() {
        return this.transaction;
    }

    public ConnectionMetaData getMetaData() {
        return new AQConnectionMetaData(this);
    }

    public ResultSetInfo getResultSetInfo() {
        throw ValidationException.operationNotSupported((String)"getResultSetInfo");
    }
}

