/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.perf;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.impl.async.DialogContext;

public class DialogPerf {
    private final DialogContext context;
    private final AtomicInteger numOutputsWritten = new AtomicInteger();
    private final AtomicInteger numInputsRead = new AtomicInteger();
    private final AtomicInteger numFramesSent = new AtomicInteger();
    private final AtomicInteger numFramesRecv = new AtomicInteger();
    private final long initTimeMs = System.currentTimeMillis();
    private final long initNs = System.nanoTime();
    private volatile long doneNs = 0L;
    private volatile List<Event> events = null;
    private volatile List<Long> timesNs = null;

    public DialogPerf(DialogContext context) {
        this.context = context;
    }

    public synchronized void startSampling() {
        if (this.events == null) {
            this.events = new ArrayList<Event>();
            this.timesNs = new ArrayList<Long>();
        }
    }

    public boolean isSampled() {
        return this.timesNs != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("initTimeMs=").append(this.initTimeMs);
        sb.append(" latencyMs=").append(String.format("%.2f", (double)this.getLatencyNs() / 1000000.0));
        sb.append(" nwrite=").append(this.numOutputsWritten.get());
        sb.append(" nread=").append(this.numInputsRead.get());
        sb.append(" nsend=").append(this.numFramesSent.get());
        sb.append(" nrecv=").append(this.numFramesRecv.get());
        sb.append(" detailed=").append(this.getDetailedTimeString(false));
        sb.append("}");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event evt) {
        switch (evt) {
            case WRITE: {
                this.numOutputsWritten.incrementAndGet();
                break;
            }
            case READ: {
                this.numInputsRead.incrementAndGet();
                break;
            }
            case SEND: {
                this.numFramesSent.incrementAndGet();
                break;
            }
            case RECV: {
                this.numFramesRecv.incrementAndGet();
                break;
            }
            case FIN: 
            case ABORT: {
                this.doneNs = System.nanoTime();
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unknown event for dialog: %s)", new Object[]{evt}));
            }
        }
        if (this.timesNs != null) {
            DialogPerf dialogPerf = this;
            synchronized (dialogPerf) {
                this.events.add(evt);
                if (evt == Event.FIN || evt == Event.ABORT) {
                    this.timesNs.add(this.doneNs);
                } else {
                    this.timesNs.add(System.nanoTime());
                }
            }
        }
    }

    public int getNumOutputsWritten() {
        return this.numOutputsWritten.get();
    }

    public int getNumInputsRead() {
        return this.numInputsRead.get();
    }

    public int getNumFramesSent() {
        return this.numFramesSent.get();
    }

    public int getNumFramesRecv() {
        return this.numFramesRecv.get();
    }

    public long getLatencyNs() {
        long latency = this.doneNs - this.initNs;
        if (latency < 0L) {
            return latency;
        }
        return latency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDetailedTimeString(boolean addContextId) {
        StringBuilder sb = new StringBuilder();
        if (addContextId) {
            sb.append(String.format("%s:%x", Long.toString(this.context.getDialogId(), 16), this.context.getConnectionId()));
        }
        sb.append("(").append(this.initTimeMs).append(")");
        if (this.timesNs != null) {
            DialogPerf dialogPerf = this;
            synchronized (dialogPerf) {
                sb.append("[");
                for (int i = 0; i < this.events.size(); ++i) {
                    sb.append((Object)this.events.get(i)).append("(").append(String.format("%.2f", (double)(this.timesNs.get(i) - this.initNs) / 1000000.0)).append(")").append(" ");
                }
                sb.append("ms]");
            }
        }
        return sb.toString();
    }

    public static enum Event {
        WRITE,
        READ,
        SEND,
        RECV,
        FIN,
        ABORT;

    }
}

