/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.FaultException;
import oracle.kv.impl.util.SerializationUtil;

public abstract class ResourceLimitException
extends FaultException {
    private static final long serialVersionUID = 1L;
    private final String tableName;

    protected ResourceLimitException(String tableName, String msg) {
        super(msg, true);
        this.tableName = tableName;
    }

    public ResourceLimitException(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.tableName = SerializationUtil.readString(in, serialVersion);
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writeString(out, serialVersion, this.tableName);
    }
}

