/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.FastExternalizableException;

public class MetadataNotFoundException
extends FastExternalizableException {
    private static final long serialVersionUID = 1L;
    private final int tableMetadataSeqNum;

    public MetadataNotFoundException(String msg, int tableMetadataSeqNum) {
        super(msg);
        this.tableMetadataSeqNum = tableMetadataSeqNum;
    }

    public MetadataNotFoundException(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.tableMetadataSeqNum = serialVersion >= 16 ? in.readInt() : 0;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (serialVersion >= 16) {
            out.writeInt(this.tableMetadataSeqNum);
        }
    }

    public int getTableMetadataSeqNum() {
        return this.tableMetadataSeqNum;
    }
}

