/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;

public class DeleteAllQueryTestHelper {
    public static String execute(Session mainSession, Class<?> referenceClass, Expression selectionExpression) {
        return DeleteAllQueryTestHelper.execute(mainSession, referenceClass, selectionExpression, true);
    }

    public static String execute(Session mainSession, Class<?> referenceClass, Expression selectionExpression, boolean shouldDeferExecutionInUOW) {
        return DeleteAllQueryTestHelper.execute(mainSession, referenceClass, selectionExpression, shouldDeferExecutionInUOW, true);
    }

    public static String execute(Session mainSession, Class<?> referenceClass, Expression selectionExpression, boolean shouldDeferExecutionInUOW, boolean handleChildren) {
        String errorMsg;
        Class rootClass = referenceClass;
        ClassDescriptor descriptor = mainSession.getClassDescriptor(referenceClass);
        if (descriptor.hasInheritance()) {
            ClassDescriptor parentDescriptor = descriptor;
            while (!parentDescriptor.getInheritancePolicy().isRootParentDescriptor()) {
                parentDescriptor = parentDescriptor.getInheritancePolicy().getParentDescriptor();
            }
            rootClass = parentDescriptor.getJavaClass();
        }
        if ((errorMsg = DeleteAllQueryTestHelper.execute(mainSession, referenceClass, selectionExpression, shouldDeferExecutionInUOW, handleChildren, rootClass)).length() == 0) {
            return null;
        }
        return errorMsg;
    }

    protected static String execute(Session mainSession, Class<?> referenceClass, Expression selectionExpression, boolean shouldDeferExecutionInUOW, boolean handleChildren, Class<?> rootClass) {
        Object remainingObjectRead;
        Object remainingObject;
        Object deletedObject;
        int i;
        Object errorMsg = "";
        DeleteAllQueryTestHelper.clearCache(mainSession);
        UnitOfWork uow = mainSession.acquireUnitOfWork();
        AbstractSession session = uow.getParent();
        session.beginTransaction();
        Vector objectsToDelete = uow.readAllObjects(referenceClass, selectionExpression);
        ClassDescriptor descriptor = mainSession.getClassDescriptor(referenceClass);
        uow.deleteAllObjects((Collection)objectsToDelete);
        mainSession.logMessage("***delete one by one");
        uow.commit();
        Vector objectsLeftAfterOriginalDeletion = session.readAllObjects(rootClass);
        session.rollbackTransaction();
        DeleteAllQueryTestHelper.clearCache(mainSession);
        session.readAllObjects(rootClass);
        uow = mainSession.acquireUnitOfWork();
        session = uow.getParent();
        session.beginTransaction();
        DeleteAllQuery query = new DeleteAllQuery(referenceClass, selectionExpression);
        query.setShouldDeferExecutionInUOW(shouldDeferExecutionInUOW);
        uow.executeQuery((DatabaseQuery)query);
        mainSession.logMessage("***DeleteAllQuery for class " + referenceClass.getName());
        uow.commit();
        Object classErrorMsg = "";
        for (i = 0; i < objectsToDelete.size(); ++i) {
            deletedObject = session.readObject(objectsToDelete.elementAt(i));
            if (deletedObject == null) continue;
            classErrorMsg = (String)classErrorMsg + "Deleted object " + deletedObject + " is stil in cache; ";
            break;
        }
        for (i = 0; i < objectsLeftAfterOriginalDeletion.size(); ++i) {
            remainingObject = objectsLeftAfterOriginalDeletion.elementAt(i);
            remainingObjectRead = session.readObject(remainingObject);
            if (remainingObjectRead != null) continue;
            classErrorMsg = (String)classErrorMsg + "Remaining object " + remainingObject + " is not in cache; ";
            break;
        }
        DeleteAllQueryTestHelper.clearCache(mainSession);
        for (i = 0; i < objectsToDelete.size(); ++i) {
            deletedObject = session.readObject(objectsToDelete.elementAt(i));
            if (deletedObject == null) continue;
            classErrorMsg = (String)classErrorMsg + "Deleted object " + deletedObject + " is stil in db; ";
            break;
        }
        for (i = 0; i < objectsLeftAfterOriginalDeletion.size(); ++i) {
            remainingObject = objectsLeftAfterOriginalDeletion.elementAt(i);
            remainingObjectRead = session.readObject(remainingObject);
            if (remainingObjectRead != null) continue;
            classErrorMsg = (String)classErrorMsg + "Remaining object " + remainingObject + " is not in db; ";
            break;
        }
        session.rollbackTransaction();
        if (((String)classErrorMsg).length() > 0) {
            String className = referenceClass.getName();
            String shortClassName = className.substring(className.lastIndexOf(46) + 1);
            errorMsg = (String)errorMsg + " " + shortClassName + ": " + (String)classErrorMsg;
        }
        if (handleChildren && descriptor.hasInheritance() && descriptor.getInheritancePolicy().hasChildren()) {
            for (ClassDescriptor childDescriptor : descriptor.getInheritancePolicy().getChildDescriptors()) {
                Class childReferenceClass = childDescriptor.getJavaClass();
                errorMsg = (String)errorMsg + DeleteAllQueryTestHelper.execute(mainSession, childReferenceClass, selectionExpression, shouldDeferExecutionInUOW, handleChildren, rootClass);
            }
        }
        return errorMsg;
    }

    protected static void clearCache(Session mainSession) {
        mainSession.getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

