/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.client.admin;

import java.rmi.RemoteException;
import java.util.logging.Logger;
import oracle.kv.impl.client.admin.DdlFuture;
import oracle.kv.impl.client.admin.DdlStatementExecutor;
import oracle.kv.impl.client.admin.ExecutionInfo;

class DdlCheckTask
implements Runnable {
    private final Logger logger;
    private final int planId;
    private final DdlStatementExecutor statementExec;
    private final int maxRetries;
    private int numRetries;

    DdlCheckTask(int planId, DdlStatementExecutor statementExec, int maxRetries, Logger logger) {
        this.planId = planId;
        this.statementExec = statementExec;
        this.maxRetries = maxRetries;
        this.logger = logger;
    }

    @Override
    public void run() {
        try {
            ExecutionInfo newInfo = this.statementExec.getClientAdminService().getExecutionStatus(this.planId);
            newInfo = DdlFuture.checkForNeedsCancel(newInfo, this.statementExec, this.planId);
            this.statementExec.updateWaiters(newInfo);
        }
        catch (RemoteException e) {
            ++this.numRetries;
            this.logger.fine("Got " + e + ", " + this.numRetries + "th retry maxRetries = " + this.maxRetries);
            if (this.numRetries > this.maxRetries) {
                this.statementExec.shutdownWaitersDueToError(this.planId, e);
            }
        }
        catch (Throwable t) {
            this.logger.info("DDL polling task for plan " + this.planId + " shut down due to " + t);
            this.statementExec.shutdownWaitersDueToError(this.planId, t);
        }
    }
}

