/*
 * Copyright (c) 2011, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
// dmccann - 2.2 - Initial implementation
package org.eclipse.persistence.testing.jaxb.externalizedmetadata.mappings.choice.reference;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;

import org.eclipse.persistence.oxm.annotations.XmlKey;
import org.eclipse.persistence.oxm.annotations.XmlPath;

public class PhoneNumber {
    @XmlAttribute(required=true)
    @XmlPath("@id")
    @XmlID
    public String id;

    @XmlElement(name="value")
    public String number;

    @XmlAttribute(required=true)
    @XmlPath("@type")
    @XmlKey
    public String type;

    public PhoneNumber() {}
    public PhoneNumber(String id, String number, String type) {
        this.id = id;
        this.number = number;
        this.type = type;
    }

    public boolean equals(Object o) {
        PhoneNumber p;
        try {
            p = (PhoneNumber) o;
        } catch (ClassCastException cce) {
            return false;
        }
        try {
            return this.id.equals(p.id) && this.number.equals(p.number) && this.type.equals(p.type);
        } catch (Exception x) {
            return false;
        }
    }
}
