/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.types;

import java.util.Date;
import java.util.Vector;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.types.TypeTester;
import org.eclipse.persistence.testing.tests.types.WriteTypeObjectTest;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class StringTester
extends TypeTester {
    public String varString;
    public String fixedString;

    public StringTester() {
        super("NULL");
        this.varString = null;
        this.fixedString = null;
    }

    public StringTester(String nameOfTest, String example) {
        super(nameOfTest);
        this.varString = example;
        this.fixedString = example;
    }

    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(StringTester.class);
        descriptor.setTableName("STRINGS");
        descriptor.setPrimaryKeyFieldName("NAME");
        descriptor.addDirectMapping("testName", "getTestName", "setTestName", "NAME");
        descriptor.addDirectMapping("varString", "VAR");
        descriptor.addDirectMapping("fixedString", "FIXED_STRING");
        return descriptor;
    }

    public static RelationalDescriptor descriptorWithAccessors() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(StringTester.class);
        descriptor.setTableName("STRINGS");
        descriptor.setPrimaryKeyFieldName("NAME");
        descriptor.addDirectMapping("testName", "getTestName", "setTestName", "NAME");
        descriptor.addDirectMapping("varString", "getVarString", "setVarString", "VAR");
        descriptor.addDirectMapping("fixedString", "getFixedString", "setFixedString", "FIXED_STRING");
        return descriptor;
    }

    public boolean equals(StringTester otherTester, Session session) throws TestWarningException {
        if (!this.getTestName().equals(otherTester.getTestName())) {
            return false;
        }
        if (!(Helper.rightTrimString((String)this.getVarString(StringTester.stringLength())).equals(otherTester.getVarString()) || this.getVarString().length() == 0 && otherTester.getVarString() == null)) {
            return false;
        }
        if (!(Helper.rightTrimString((String)this.getFixedString(StringTester.stringLength())).equals(otherTester.getFixedString()) || this.getFixedString().length() == 0 && otherTester.getFixedString() == null)) {
            return false;
        }
        if (otherTester.getFixedString() == null || otherTester.getVarString() == null) {
            throw new TestWarningException("Empty columns can be returned as NULL.");
        }
        return true;
    }

    public String getFixedString() {
        return this.fixedString;
    }

    public String getFixedString(int fieldLength) {
        if (this.fixedString.length() > StringTester.stringLength()) {
            return this.fixedString.substring(0, StringTester.stringLength());
        }
        return this.fixedString;
    }

    public String getVarString() {
        return this.varString;
    }

    public String getVarString(int fieldLength) {
        if (this.varString.length() > StringTester.stringLength()) {
            return this.varString.substring(0, StringTester.stringLength());
        }
        return this.varString;
    }

    public void setFixedString(String aString) {
        this.fixedString = aString;
    }

    public void setVarString(String aString) {
        this.varString = aString;
    }

    public static int stringLength() {
        return 30;
    }

    public static TableDefinition tableDefinition(Session session) {
        TableDefinition definition = TypeTester.tableDefinition();
        definition.setName("STRINGS");
        definition.addField("VAR", String.class, StringTester.stringLength());
        definition.addField("FIXED_STRING", Character.class, StringTester.stringLength());
        return definition;
    }

    public static Vector testInstances() {
        Vector<StringTester> tests = new Vector<StringTester>();
        tests.addElement(new StringTester());
        tests.addElement(new StringTester("Empty", ""));
        tests.addElement(new StringTester("Date", new Date().toString()));
        tests.addElement(new StringTester("Too Long", "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"));
        tests.addElement(new StringTester("Leading Blanks", "     5 blanks"));
        tests.addElement(new StringTester("Trailing Blanks", "5 blanks     "));
        tests.addElement(new StringTester("Quotes", "\"'`"));
        return tests;
    }

    public String toString() {
        return "StringTester(" + this.getTestName() + ")";
    }

    @Override
    protected void verify(WriteTypeObjectTest testCase) throws TestErrorException, TestWarningException {
        if (this.caughtException != null && this.getVarString().length() > 30) {
            throw new TestWarningException("Too long exception: " + this.caughtException.toString());
        }
        try {
            super.verify(testCase);
        }
        catch (TestErrorException verifyFailedException) {
            String fixed;
            if (testCase.getObjectFromDatabase() != null && (fixed = ((StringTester)testCase.getObjectFromDatabase()).getFixedString()) != null && fixed.length() > 0 && fixed.charAt(fixed.length() - 1) == ' ') {
                if (fixed.equals(" ")) {
                    throw new TestWarningException("This driver converts '''' to '' ''.");
                }
                throw new TestErrorException("Trailing blanks were not removed from char field.");
            }
            if (this.getVarString().length() == 0 && ((StringTester)testCase.getObjectFromDatabase()).getVarString() == null) {
                throw new TestWarningException("A null was returned for the empty string");
            }
            if (this.getVarString().length() == 0 && ((StringTester)testCase.getObjectFromDatabase()).getVarString().equals(" ")) {
                throw new TestWarningException("A single space string was returned instead of an empty string");
            }
            if (this.getVarString().length() > 0 && this.getVarString().charAt(this.getVarString().length() - 1) == ' ' && this.getVarString().trim().equals(((StringTester)testCase.getObjectFromDatabase()).getVarString())) {
                throw new TestWarningException("Trailing blanks were removed");
            }
            if (this.getVarString().length() > 0 && this.getVarString().charAt(0) == ' ' && this.getVarString().trim().equals(((StringTester)testCase.getObjectFromDatabase()).getVarString())) {
                throw new TestWarningException("Leading blanks were removed");
            }
            if (this.getVarString().length() > 30 && ((StringTester)testCase.getObjectFromDatabase()).getVarString().length() == 30 && this.getVarString().startsWith(((StringTester)testCase.getObjectFromDatabase()).getVarString())) {
                throw new TestWarningException("The string was truncated.");
            }
            if (this.getFixedString().length() > 0 && this.getFixedString().charAt(this.getFixedString().length() - 1) == ' ' && this.getFixedString().trim().equals(((StringTester)testCase.getObjectFromDatabase()).getFixedString())) {
                throw new TestWarningException("Trailing blanks were removed from char field.");
            }
            if (this.caughtException != null) {
                throw this.caughtException;
            }
            throw verifyFailedException;
        }
    }
}

