/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreFactory;
import oracle.kv.KeyValueVersion;
import oracle.kv.StoreIteratorConfig;
import oracle.kv.hadoop.KVInputSplit;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.parallelscan.ParallelScan;
import oracle.kv.impl.security.util.KVStoreLogin;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

abstract class KVRecordReaderBase<K, V>
extends RecordReader<K, V> {
    protected KVStoreImpl kvstore;
    protected KeyValueVersion current;
    private KVInputSplit kvInputSplit;
    private List<Set<Integer>> partitionSets;
    private int startNPartitionSets;
    private Iterator<KeyValueVersion> iter;

    KVRecordReaderBase() {
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        if (this.kvstore != null) {
            this.close();
        }
        this.kvInputSplit = (KVInputSplit)split;
        String kvStoreName = this.kvInputSplit.getKVStoreName();
        String[] kvHelperHosts = this.kvInputSplit.getKVHelperHosts();
        String kvStoreSecurityFile = this.kvInputSplit.getKVStoreSecurityFile();
        KVStoreConfig storeConfig = new KVStoreConfig(kvStoreName, kvHelperHosts);
        storeConfig.setSecurityProperties(KVStoreLogin.createSecurityProperties(kvStoreSecurityFile));
        this.kvstore = (KVStoreImpl)KVStoreFactory.getStore(storeConfig);
        int singlePartId = this.kvInputSplit.getKVPart();
        this.partitionSets = singlePartId == 0 ? this.kvInputSplit.getPartitionSets() : Collections.singletonList(Collections.singleton(singlePartId));
        this.startNPartitionSets = this.partitionSets.size();
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        try {
            if (this.iter == null) {
                this.iter = this.getNextIterator();
            }
            while (this.iter != null) {
                if (this.iter.hasNext()) {
                    this.current = this.iter.next();
                    return true;
                }
                this.current = null;
                this.iter = this.getNextIterator();
            }
            return false;
        }
        catch (Exception E) {
            System.out.println("KVRecordReaderBase " + (Object)((Object)this) + " caught: " + E);
            E.printStackTrace();
            return false;
        }
    }

    private Iterator<KeyValueVersion> getNextIterator() {
        if (this.partitionSets.isEmpty()) {
            return null;
        }
        Set<Integer> partitions = this.partitionSets.remove(0);
        assert (partitions.size() > 0);
        return partitions.size() == 1 ? this.kvstore.partitionIterator(this.kvInputSplit.getDirection(), this.kvInputSplit.getBatchSize(), (Integer)partitions.toArray()[0], this.kvInputSplit.getParentKey(), this.kvInputSplit.getSubRange(), this.kvInputSplit.getDepth(), this.kvInputSplit.getConsistency(), this.kvInputSplit.getTimeout(), this.kvInputSplit.getTimeoutUnit()) : ParallelScan.createParallelScan(this.kvstore, this.kvInputSplit.getDirection(), this.kvInputSplit.getBatchSize(), this.kvInputSplit.getParentKey(), this.kvInputSplit.getSubRange(), this.kvInputSplit.getDepth(), this.kvInputSplit.getConsistency(), this.kvInputSplit.getTimeout(), this.kvInputSplit.getTimeoutUnit(), new StoreIteratorConfig(), partitions);
    }

    public float getProgress() {
        return this.partitionSets == null ? 0.0f : (float)(this.startNPartitionSets - this.partitionSets.size()) / (float)this.startNPartitionSets;
    }

    public void close() {
        this.kvstore.close();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.startNPartitionSets + ", " + this.getProgress() + "]";
    }
}

