/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.xjc;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JPrimitiveType;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaClassImpl;

public class XJCJavaFieldImpl
implements JavaField {
    private JFieldVar xjcField;
    private JCodeModel jCodeModel;
    private DynamicClassLoader dynamicClassLoader;
    private JavaClass owningClass;

    public XJCJavaFieldImpl(JFieldVar javaField, JCodeModel codeModel, DynamicClassLoader loader, JavaClass owner) {
        this.xjcField = javaField;
        this.jCodeModel = codeModel;
        this.dynamicClassLoader = loader;
        this.owningClass = owner;
    }

    @Override
    public JavaAnnotation getAnnotation(JavaClass aClass) {
        if (aClass != null) {
            Collection annotations = this.xjcField.annotations();
            for (JAnnotationUse annotationUse : annotations) {
                XJCJavaAnnotationImpl xjcAnnotation = new XJCJavaAnnotationImpl(annotationUse, this.dynamicClassLoader);
                if (!xjcAnnotation.getJavaAnnotationClass().getCanonicalName().equals(aClass.getQualifiedName())) continue;
                return xjcAnnotation;
            }
            return null;
        }
        return null;
    }

    @Override
    public Collection<JavaAnnotation> getAnnotations() {
        ArrayList<JavaAnnotation> annotationsList = new ArrayList<JavaAnnotation>();
        Collection annotations = this.xjcField.annotations();
        for (JAnnotationUse annotationUse : annotations) {
            XJCJavaAnnotationImpl xjcAnnotation = new XJCJavaAnnotationImpl(annotationUse, this.dynamicClassLoader);
            annotationsList.add(xjcAnnotation);
        }
        return annotationsList;
    }

    @Override
    public int getModifiers() {
        return this.xjcField.mods().getValue();
    }

    @Override
    public String getName() {
        return this.xjcField.name();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public JavaClass getResolvedType() {
        type = this.xjcField.type();
        basis = type.erasure();
        isArray = false;
        isPrimitive = false;
        classToReturn = null;
        if (type.isPrimitive()) {
            pType = (JPrimitiveType)type;
            classToReturn = pType.boxify();
        } else if (type.getClass().getName().contains("JArrayClass")) {
            isArray = true;
            classToReturn = (JClass)type;
            try {
                componentType = type.elementType();
                if (!componentType.isPrimitive()) ** GOTO lbl25
                isPrimitive = true;
            }
            catch (Exception e) {
                throw JAXBException.errorCreatingDynamicJAXBContext((Exception)e);
            }
        } else {
            try {
                classToReturn = this.jCodeModel._class(basis != null ? basis.fullName() : type.fullName());
            }
            catch (JClassAlreadyExistsException ex) {
                classToReturn = this.jCodeModel._getClass(basis != null ? basis.fullName() : type.fullName());
            }
        }
lbl25:
        // 5 sources

        if (basis instanceof JClass) {
            args = ((JClass)type).getTypeParameters();
            for (JClass jClass : args) {
                ((JDefinedClass)classToReturn).generify("param", jClass);
            }
        }
        className = classToReturn.fullName();
        if (isArray) {
            className = (String)className + "[]";
        }
        if (((XJCJavaClassImpl)this.getOwningClass()).getJavaModel() != null) {
            return ((XJCJavaClassImpl)this.getOwningClass()).getJavaModel().getClass((String)className);
        }
        return new XJCJavaClassImpl((JDefinedClass)classToReturn, this.jCodeModel, this.dynamicClassLoader, isArray, isPrimitive);
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public boolean isSynthetic() {
        throw new UnsupportedOperationException("isSynthetic");
    }

    @Override
    public boolean isEnumConstant() {
        return this.getOwningClass().isEnum();
    }

    @Override
    public JavaAnnotation getDeclaredAnnotation(JavaClass aClass) {
        return this.getAnnotation(aClass);
    }

    @Override
    public Collection<JavaAnnotation> getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    public void setOwningClass(JavaClass owningClass) {
        this.owningClass = owningClass;
    }

    public JavaClass getOwningClass() {
        return this.owningClass;
    }
}

