/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.code;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.classfilewriter.code.BranchEnd;
import org.jboss.classfilewriter.code.CodeLocation;

public class LookupSwitchBuilder {
    private final CodeLocation defaultLocation;
    private final AtomicReference<BranchEnd> defaultBranchEnd;
    private final List<ValuePair> values = new ArrayList<ValuePair>();

    public LookupSwitchBuilder() {
        this.defaultBranchEnd = new AtomicReference();
        this.defaultLocation = null;
    }

    public LookupSwitchBuilder(CodeLocation defaultLocation) {
        this.defaultLocation = defaultLocation;
        this.defaultBranchEnd = null;
    }

    public AtomicReference<BranchEnd> add(int value) {
        AtomicReference<BranchEnd> end = new AtomicReference<BranchEnd>();
        ValuePair vp = new ValuePair(value, end);
        this.values.add(vp);
        return end;
    }

    public LookupSwitchBuilder add(int value, CodeLocation location) {
        this.values.add(new ValuePair(value, location));
        return this;
    }

    public CodeLocation getDefaultLocation() {
        return this.defaultLocation;
    }

    public AtomicReference<BranchEnd> getDefaultBranchEnd() {
        return this.defaultBranchEnd;
    }

    public List<ValuePair> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public static class ValuePair
    implements Comparable<ValuePair> {
        private final int value;
        private final CodeLocation location;
        private final AtomicReference<BranchEnd> branchEnd;

        public ValuePair(int value, AtomicReference<BranchEnd> branchEnd) {
            this.value = value;
            this.location = null;
            this.branchEnd = branchEnd;
        }

        public ValuePair(int value, CodeLocation location) {
            this.value = value;
            this.location = location;
            this.branchEnd = null;
        }

        @Override
        public int compareTo(ValuePair o) {
            return Integer.valueOf(this.value).compareTo(o.value);
        }

        public int getValue() {
            return this.value;
        }

        public CodeLocation getLocation() {
            return this.location;
        }

        public AtomicReference<BranchEnd> getBranchEnd() {
            return this.branchEnd;
        }
    }
}

