/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.reconciler;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.ContentAssistantFacade;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension4;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextDocumentContentObserver;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.ui.editor.reconciler.Messages;
import org.eclipse.xtext.ui.editor.reconciler.ReconcilerReplaceRegion;
import org.eclipse.xtext.ui.editor.reconciler.ReplaceRegion;
import org.eclipse.xtext.ui.editor.reconciler.TemplatePositionUpdater;
import org.eclipse.xtext.ui.editor.reconciler.XtextDocumentReconcileStrategy;
import org.eclipse.xtext.util.DiffUtil;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class XtextReconciler
extends Job
implements IReconciler {
    private static final Logger log = Logger.getLogger(XtextReconciler.class);
    private boolean isInstalled;
    private boolean shouldInstallCompletionListener;
    private volatile boolean paused;
    private volatile XtextEditor editor;
    private ITextViewer textViewer;
    private TextInputListener textInputListener;
    private final DocumentListener documentListener;
    private int delay;
    private IReconcilingStrategy strategy;
    private boolean initalProcessDone;
    @Inject
    private OperationCanceledManager canceledManager;
    private LinkedBlockingQueue<DocumentEvent> pendingChanges = new LinkedBlockingQueue();

    @Inject
    public XtextReconciler(XtextDocumentReconcileStrategy strategy) {
        super(Messages.XtextReconciler_JobName);
        this.setPriority(20);
        this.setSystem(true);
        this.isInstalled = false;
        this.documentListener = new DocumentListener();
        this.paused = false;
        this.shouldInstallCompletionListener = false;
        this.setDelay(500);
        this.setReconcilingStrategy(strategy);
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        return this.strategy;
    }

    public void setReconcilingStrategy(IReconcilingStrategy strategy) {
        this.strategy = strategy;
    }

    public void install(ITextViewer textViewer) {
        if (!this.isInstalled) {
            this.textViewer = textViewer;
            this.textInputListener = new TextInputListener();
            textViewer.addTextInputListener((ITextInputListener)this.textInputListener);
            this.handleInputDocumentChanged(null, textViewer.getDocument());
            if (textViewer instanceof ISourceViewerExtension4) {
                ContentAssistantFacade facade = ((ISourceViewerExtension4)textViewer).getContentAssistantFacade();
                if (facade == null) {
                    this.shouldInstallCompletionListener = true;
                } else {
                    facade.addCompletionListener((ICompletionListener)this.documentListener);
                }
                if (this.strategy instanceof ISourceViewerAware) {
                    ((ISourceViewerAware)this.strategy).setSourceViewer((ISourceViewer)textViewer);
                }
            }
            this.isInstalled = true;
        }
    }

    public void uninstall() {
        if (this.isInstalled) {
            this.textViewer.removeTextInputListener((ITextInputListener)this.textInputListener);
            this.isInstalled = false;
            if (this.documentListener != null) {
                if (this.textViewer instanceof ISourceViewerExtension4) {
                    ContentAssistantFacade facade = ((ISourceViewerExtension4)this.textViewer).getContentAssistantFacade();
                    facade.removeCompletionListener((ICompletionListener)this.documentListener);
                }
                if (this.textViewer.getDocument() instanceof IXtextDocument) {
                    ((IXtextDocument)this.textViewer.getDocument()).removeXtextDocumentContentObserver(this.documentListener);
                }
            }
        }
    }

    protected void handleInputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (Display.getCurrent() == null) {
            log.error((Object)"Changes to the document must only be applied from the Display thread to keep them ordered", (Throwable)new Exception());
        }
        if (this.shouldInstallCompletionListener) {
            ContentAssistantFacade facade = ((ISourceViewerExtension4)this.textViewer).getContentAssistantFacade();
            if (facade != null) {
                facade.addCompletionListener((ICompletionListener)this.documentListener);
            }
            this.shouldInstallCompletionListener = false;
        }
        if (oldInput != newInput) {
            if (oldInput instanceof IXtextDocument) {
                ((IXtextDocument)oldInput).removeXtextDocumentContentObserver(this.documentListener);
            }
            if (newInput instanceof IXtextDocument) {
                ((IXtextDocument)newInput).addXtextDocumentContentObserver(this.documentListener);
                IXtextDocument document = XtextDocumentUtil.get(this.textViewer);
                this.strategy.setDocument((IDocument)document);
                if (!this.initalProcessDone && this.strategy instanceof IReconcilingStrategyExtension) {
                    this.initalProcessDone = true;
                    IReconcilingStrategyExtension reconcilingStrategyExtension = (IReconcilingStrategyExtension)this.strategy;
                    reconcilingStrategyExtension.initialReconcile();
                }
            }
        }
        if (oldInput != null && newInput != null) {
            this.handleDocumentChanged(new InputChangedDocumentEvent(oldInput, newInput));
        }
    }

    private void handleDocumentChanged(DocumentEvent event) {
        this.cancel();
        if (log.isTraceEnabled()) {
            log.trace((Object)"Reconciler cancelled");
        }
        this.reallyEnqueueEvent(event);
        this.schedule(this.delay);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Reconciler scheduled with delay: " + this.delay));
        }
    }

    public void forceReconcile() {
        if (this.editor != null && this.editor.getDocument() != null) {
            DocumentEvent dummyEvent = new DocumentEvent((IDocument)this.editor.getDocument(), 0, 0, "");
            this.handleDocumentChanged(dummyEvent);
        }
    }

    private void reallyEnqueueEvent(DocumentEvent event) {
        try {
            this.pendingChanges.put(event);
        }
        catch (InterruptedException e) {
            this.reallyEnqueueEvent(event);
        }
    }

    protected void pause() {
        this.paused = true;
    }

    protected void resume() {
        this.paused = false;
        this.schedule(this.delay);
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public boolean belongsTo(Object family) {
        return XtextReconciler.class.getName().equals(family);
    }

    protected IStatus run(final IProgressMonitor monitor) {
        if (monitor.isCanceled() || this.paused) {
            return Status.CANCEL_STATUS;
        }
        if (this.pendingChanges.isEmpty()) {
            return Status.OK_STATUS;
        }
        long start = System.currentTimeMillis();
        IXtextDocument document = XtextDocumentUtil.get(this.textViewer);
        if (document instanceof XtextDocument) {
            ((XtextDocument)document).internalModify(new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource state) throws Exception {
                    XtextReconciler.this.doRun(state, monitor);
                }
            });
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reconciliation finished. Time required: " + (System.currentTimeMillis() - start)));
        }
        return Status.OK_STATUS;
    }

    protected String getResourceText(XtextResource resource) {
        IParseResult parseResult = resource.getParseResult();
        return parseResult != null ? parseResult.getRootNode().getText() : "";
    }

    private ReconcilerReplaceRegion getMergedReplaceRegion(XtextResource resource) {
        ArrayList events = Lists.newArrayListWithExpectedSize((int)this.pendingChanges.size());
        this.pendingChanges.drainTo(events);
        if (events.isEmpty() || resource == null) {
            return null;
        }
        String resourceText = this.getResourceText(resource);
        ReconcilerReplaceRegion.Builder builder = ReconcilerReplaceRegion.builder(resourceText);
        for (DocumentEvent event : events) {
            if (event instanceof InputChangedDocumentEvent) {
                builder = ReconcilerReplaceRegion.builder(resourceText);
                if (resourceText.equals(event.getText())) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resource text is not up-to-date:\n" + DiffUtil.diff((String)resourceText, (String)event.getText())));
                }
                builder.add(0, resourceText.length(), event.getText());
                continue;
            }
            builder.add(event.getOffset(), event.getLength(), event.getText());
        }
        ReconcilerReplaceRegion mergedRegion = builder.create();
        mergedRegion.setModificationStamp(((DocumentEvent)events.get(events.size() - 1)).getModificationStamp());
        if (log.isDebugEnabled()) {
            for (DocumentEvent event : events) {
                mergedRegion.addDocumentEvent(event);
            }
        }
        return mergedRegion;
    }

    @Deprecated
    protected ReplaceRegion getAndResetReplaceRegion() {
        return null;
    }

    private boolean doRun(XtextResource state, IProgressMonitor monitor) {
        ReconcilerReplaceRegion replaceRegionToBeProcessed;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Preparing reconciliation.");
        }
        if ((replaceRegionToBeProcessed = this.getMergedReplaceRegion(state)) != null) {
            try {
                if (this.strategy instanceof IReconcilingStrategyExtension) {
                    ((IReconcilingStrategyExtension)this.strategy).setProgressMonitor((IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
                }
                if (this.strategy instanceof XtextDocumentReconcileStrategy) {
                    XtextDocumentReconcileStrategy xtextDocumentReconcileStrategy = (XtextDocumentReconcileStrategy)this.strategy;
                    xtextDocumentReconcileStrategy.setResource(state);
                    xtextDocumentReconcileStrategy.setEditor(this.editor);
                }
                this.strategy.reconcile((IRegion)replaceRegionToBeProcessed);
            }
            finally {
                if (this.strategy instanceof IReconcilingStrategyExtension) {
                    ((IReconcilingStrategyExtension)this.strategy).setProgressMonitor(null);
                }
                if (this.strategy instanceof XtextDocumentReconcileStrategy) {
                    XtextDocumentReconcileStrategy xtextDocumentReconcileStrategy = (XtextDocumentReconcileStrategy)this.strategy;
                    xtextDocumentReconcileStrategy.setResource(null);
                    xtextDocumentReconcileStrategy.setEditor(null);
                }
            }
            return true;
        }
        return false;
    }

    public void setEditor(XtextEditor editor) {
        this.editor = editor;
    }

    protected class DocumentListener
    implements IXtextDocumentContentObserver,
    ICompletionListener {
        private final IPositionUpdater templatePositionUpdater = new TemplatePositionUpdater("xtext_template_position_category");
        private volatile boolean sessionStarted = false;

        protected DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (Display.getCurrent() == null) {
                log.error((Object)"Changes to the document must only be applied from the Display thread to keep them ordered", (Throwable)new Exception());
            }
            XtextReconciler.this.handleDocumentChanged(event);
        }

        @Override
        public boolean performNecessaryUpdates(IXtextDocumentContentObserver.Processor processor) {
            boolean hadUpdates = false;
            try {
                if (!XtextReconciler.this.pendingChanges.isEmpty()) {
                    hadUpdates = processor.process(new IUnitOfWork<Boolean, XtextResource>(){

                        public Boolean exec(XtextResource state) throws Exception {
                            return XtextReconciler.this.doRun(state, null);
                        }
                    });
                }
            }
            catch (Exception exc) {
                XtextReconciler.this.canceledManager.propagateAsErrorIfCancelException((Throwable)exc);
                log.error((Object)"Error while forcing reconciliation", (Throwable)exc);
            }
            if (this.sessionStarted && !XtextReconciler.this.paused) {
                XtextReconciler.this.pause();
            }
            return hadUpdates;
        }

        @Override
        public boolean hasPendingUpdates() {
            return !XtextReconciler.this.pendingChanges.isEmpty();
        }

        public void assistSessionStarted(ContentAssistEvent event) {
            IDocument document = XtextReconciler.this.textViewer.getDocument();
            document.addPositionCategory("xtext_template_position_category");
            document.addPositionUpdater(this.templatePositionUpdater);
            this.sessionStarted = true;
        }

        public void assistSessionEnded(ContentAssistEvent event) {
            this.sessionStarted = false;
            IDocument document = XtextReconciler.this.textViewer.getDocument();
            document.removePositionUpdater(this.templatePositionUpdater);
            try {
                document.removePositionCategory("xtext_template_position_category");
            }
            catch (BadPositionCategoryException e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            XtextReconciler.this.resume();
        }

        public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        }
    }

    protected class InputChangedDocumentEvent
    extends DocumentEvent {
        public InputChangedDocumentEvent(IDocument oldInput, IDocument newInput) {
            super(newInput, 0, oldInput.getLength(), newInput.get());
        }
    }

    protected class TextInputListener
    implements ITextInputListener {
        protected TextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            XtextReconciler.this.handleInputDocumentChanged(oldInput, newInput);
        }
    }
}

