/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.validation;

import java.util.Locale;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.validation.LocalizedMessage;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public class JSDTSourceValidator
extends AbstractValidator
implements IValidatorJob,
IExecutableExtension,
ISourceValidator {
    private static final ASTParser parser = ASTParser.newParser((int)3);
    private String[] fAdditionalContentTypesIDs = null;
    private IDocument fDocument;

    static boolean shouldValidate(IFile file) {
        IProject project = file.getProject();
        JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
        JavaProject javaProject = (JavaProject)model.getJavaProject((IResource)project);
        if (!javaProject.exists() || !javaProject.isOnIncludepath((IResource)file)) {
            return false;
        }
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && (resource.getName().charAt(0) != '.' || resource.getType() != 2)) continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        if (helper == null) {
            return;
        }
        if (reporter != null && reporter.isCancelled()) {
            throw new OperationCanceledException();
        }
        String[] deltaArray = helper.getURIs();
        if (deltaArray != null && deltaArray.length > 0) {
            this.validateDelta(helper, reporter);
        } else {
            this.validateFull(helper, reporter);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fAdditionalContentTypesIDs = new String[0];
        if (data instanceof String && data.toString().length() > 0) {
            this.fAdditionalContentTypesIDs = StringUtils.unpack((String)data.toString());
        }
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        IStatus status = Status.OK_STATUS;
        this.validate(helper, reporter);
        return status;
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    public void connect(IDocument document) {
        this.fDocument = document;
    }

    public void disconnect(IDocument document) {
        this.fDocument = null;
    }

    public void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter) {
        if (helper == null || this.fDocument == null) {
            return;
        }
        if (reporter != null && reporter.isCancelled()) {
            throw new OperationCanceledException();
        }
    }

    private void validateContainer(IValidationContext helper, IReporter reporter, IContainer container) {
        try {
            IResource[] resourceArray = container.members(false);
            int i = 0;
            while (i < resourceArray.length) {
                IResource resource = resourceArray[i];
                if (resource != null && !reporter.isCancelled()) {
                    if (resource instanceof IFile) {
                        LocalizedMessage message = new LocalizedMessage(4, resource.getFullPath().toString().substring(1));
                        reporter.displaySubtask((IValidator)this, (IMessage)message);
                        this.validateFile(helper, reporter, (IFile)resource, null);
                    } else if (resource instanceof IContainer) {
                        this.validateContainer(helper, reporter, (IContainer)resource);
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    private void validateDelta(IValidationContext helper, IReporter reporter) {
        String[] deltaArray = helper.getURIs();
        int i = 0;
        while (i < deltaArray.length) {
            String delta = deltaArray[i];
            if (delta != null) {
                IResource resource;
                if (reporter != null) {
                    LocalizedMessage message = new LocalizedMessage(4, delta.substring(1));
                    reporter.displaySubtask((IValidator)this, (IMessage)message);
                }
                if ((resource = this.getResource(delta)) != null && resource instanceof IFile) {
                    this.validateFile(helper, reporter, (IFile)resource, null);
                }
            }
            ++i;
        }
    }

    private void validateFile(IValidationContext helper, IReporter reporter, IFile file, ValidationResult result) {
        if (reporter != null && reporter.isCancelled()) {
            throw new OperationCanceledException();
        }
        if (!JSDTSourceValidator.shouldValidate(file)) {
            return;
        }
        char[] source = this.fDocument.get().toCharArray();
        if (source == null) {
            return;
        }
        parser.setSource(source);
        parser.setProject(JavaScriptCore.create((IProject)file.getProject()));
        JavaScriptUnit unit = (JavaScriptUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
        if (unit == null) {
            Message valMessage = new Message("org.eclipse.wst.jsdt.ui", 1, "org.eclipse.wst.jsdt.ui.problem"){

                public String getText(Locale locale, ClassLoader classLoader) {
                    return "AST couldn't be created due to the fatal error";
                }
            };
            valMessage.setOffset(0);
            valMessage.setLength(0);
            valMessage.setLineNo(0);
            reporter.addMessage((IValidator)this, (IMessage)valMessage);
        } else if (unit.getProblems().length > 0) {
            IProblem[] iProblemArray = unit.getProblems();
            int n = iProblemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProblem problem = iProblemArray[n2];
                final String msg = problem.getMessage();
                problem.getArguments();
                int severity = problem.isError() ? 1 : 3;
                int lineNumber = problem.getSourceLineNumber();
                int sourceStart = problem.getSourceStart();
                int sourceEnd = problem.getSourceEnd();
                if (problem instanceof DefaultProblem) {
                    ((DefaultProblem)problem).getSourceColumnNumber();
                }
                Message valMessage = new Message("org.eclipse.wst.jsdt.ui", severity, "org.eclipse.wst.jsdt.ui.problem"){

                    public String getText(Locale locale, ClassLoader classLoader) {
                        return msg;
                    }
                };
                Position position = sourceEnd == -1 ? this.calcPosition(source, sourceStart) : new Position(sourceStart, sourceEnd - sourceStart);
                valMessage.setOffset(position.getOffset());
                valMessage.setLength(position.getLength());
                valMessage.setLineNo(lineNumber);
                reporter.addMessage((IValidator)this, (IMessage)valMessage);
                ++n2;
            }
        }
    }

    private Position calcPosition(char[] source, int offset) {
        int start;
        int end = start = offset > source.length ? source.length : offset;
        while (source.length > end && (Character.isLetterOrDigit(source[end]) || source[end] == '_')) {
            ++end;
        }
        if (end == start) {
            boolean acceptSemiColon = true;
            while (end > 0 && (acceptSemiColon && source[end - 1] == ';' || Character.isWhitespace(source[end - 1]))) {
                if (source[end - 1] == ';') {
                    acceptSemiColon = false;
                }
                --end;
            }
            start = end;
            while (start > 0 && (Character.isLetterOrDigit(source[start - 1]) || source[start - 1] == '_')) {
                --start;
            }
        }
        return new Position(start, end - start);
    }

    private void validateFull(IValidationContext helper, IReporter reporter) {
        IProject project = null;
        String[] fileDelta = helper.getURIs();
        if (helper instanceof IWorkbenchContext) {
            IWorkbenchContext wbHelper = (IWorkbenchContext)helper;
            project = wbHelper.getProject();
        } else if (fileDelta.length > 0) {
            project = this.getResource(fileDelta[0]).getProject();
        }
        if (project == null) {
            return;
        }
        this.validateContainer(helper, reporter, (IContainer)project);
    }

    public IResource getResource(String delta) {
        Path path = new Path(delta);
        if (path.segmentCount() > 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        if (path.segmentCount() == 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(delta);
        }
        return null;
    }
}

