/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.npm.internal.wizard;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.wst.jsdt.js.common.ui.PopUpKeyValueDialog;
import org.eclipse.wst.jsdt.js.common.util.WorkbenchResourceUtil;
import org.eclipse.wst.jsdt.js.npm.PackageJson;
import org.eclipse.wst.jsdt.js.npm.internal.Messages;
import org.eclipse.wst.jsdt.js.npm.internal.NpmConstants;

public class NpmInitPage
extends WizardPage {
    private final IStructuredSelection selection;
    private IContainer selectedContainer;
    private Text dirText;
    private Text nameText;
    private Text versionText;
    private Text descriptionText;
    private Text mainText;
    private Text authorText;
    private Text licenseText;
    private Button useDefaultCheckBox;
    private Table scriptsTable;
    private Button addScriptButton;
    private String defaultName;
    private String defaultVersion;
    private String defaultDescription;
    private String defaultMain;
    private String defaultAuthor;
    private String defaultLicense;
    private String defaultDirectory;
    private Map<String, String> defaultScripts;

    public NpmInitPage(IStructuredSelection selection) {
        super(Messages.NpmInitWizard_PageName);
        this.setTitle(Messages.NpmInitWizard_PageTitle);
        this.setDescription(Messages.NpmInitWizard_PageDescription);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite mainComposite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
        ((GridLayout)mainComposite.getLayout()).verticalSpacing = 4;
        this.createExecutionDirEditor(mainComposite);
        this.createUseDefaultsEditor(mainComposite);
        this.createBasePropertyEditor(mainComposite);
        this.createScriptsEditor(mainComposite);
        Dialog.applyDialogFont((Control)mainComposite);
        this.initiDefaultsValues();
        this.setControl((Control)mainComposite);
    }

    public String getExecutionDir() {
        return this.dirText.getText();
    }

    public PackageJson getModel() {
        String name = this.nameText.getText();
        String version = this.versionText.getText();
        String description = this.descriptionText.getText();
        String main = this.mainText.getText();
        String author = this.authorText.getText();
        String license = this.licenseText.getText();
        Map<String, String> scripts = this.getKeyValueItems(this.scriptsTable);
        PackageJson.Builder builder = new PackageJson.Builder();
        if (name != null && !name.isEmpty()) {
            builder.name(name);
        }
        if (version != null && !version.isEmpty()) {
            builder.version(version);
        }
        if (description != null) {
            builder.description(description);
        }
        if (main != null && !main.isEmpty()) {
            builder.main(main);
        }
        if (scripts != null && !scripts.isEmpty()) {
            builder.scripts(scripts);
        }
        if (author != null) {
            builder.author(author);
        }
        if (license != null && !license.isEmpty()) {
            builder.license(license);
        }
        PackageJson model = builder.build();
        return model;
    }

    private void initiDefaultsValues() {
        this.selectedContainer = WorkbenchResourceUtil.getContainerFromSelection((IStructuredSelection)this.selection);
        String location = WorkbenchResourceUtil.getAbsolutePath((IResource)this.selectedContainer);
        this.defaultDirectory = location != null ? location : "";
        this.defaultName = this.selectedContainer != null ? this.selectedContainer.getProject().getName().replaceAll("\\s", "") : "js";
        this.defaultVersion = "0.0.0";
        this.defaultLicense = "ISC";
        this.defaultDescription = "Generated with Eclipse npm Tools";
        this.defaultMain = "index.js";
        this.defaultAuthor = "";
        this.defaultScripts = NpmConstants.DEFAULT_SCRIPTS;
        this.dirText.setText(this.defaultDirectory);
        this.nameText.setText(this.defaultName);
        this.versionText.setText(this.defaultVersion);
        this.descriptionText.setText(this.defaultDescription);
        this.mainText.setText(this.defaultMain);
        this.authorText.setText(this.defaultAuthor);
        this.licenseText.setText(this.defaultLicense);
        this.setDefaults(this.scriptsTable, this.defaultScripts);
        boolean useDefault = this.useDefaultCheckBox.getSelection();
        this.nameText.setEnabled(!useDefault);
        this.versionText.setEnabled(!useDefault);
        this.descriptionText.setEnabled(!useDefault);
        this.mainText.setEnabled(!useDefault);
        this.authorText.setEnabled(!useDefault);
        this.licenseText.setEnabled(!useDefault);
        this.scriptsTable.setEnabled(!useDefault);
        this.addScriptButton.setEnabled(!useDefault);
    }

    private void createExecutionDirEditor(Composite mainComposite) {
        Label label = new Label(mainComposite, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        label.setText(Messages.NpmInitWizard_BaseDirectory);
        this.dirText = new Text(mainComposite, 2048);
        this.dirText.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 5, 1));
        this.dirText.addModifyListener((ModifyListener)new EntriesChangedListener());
        Composite buttonComposite = new Composite(mainComposite, 0);
        buttonComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 5, 1));
        GridLayout buttonGridLayout = new GridLayout();
        buttonGridLayout.marginWidth = 0;
        buttonGridLayout.marginHeight = 0;
        buttonGridLayout.numColumns = 1;
        buttonComposite.setLayout((Layout)buttonGridLayout);
        Button browseWorkspaceButton = new Button(buttonComposite, 0);
        browseWorkspaceButton.setText(Messages.NpmInitWizard_BrowseWorkspace);
        browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] resource;
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(NpmInitPage.this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.NpmInitWizard_RootFolderSelection);
                dialog.showClosedProjects(false);
                int buttonId = dialog.open();
                if (buttonId == 0 && (resource = dialog.getResult()) != null && resource.length > 0) {
                    IPath path = (IPath)resource[0];
                    IResource selectedResource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                    String location = WorkbenchResourceUtil.getAbsolutePath((IResource)selectedResource);
                    if (selectedResource.exists()) {
                        NpmInitPage.this.dirText.setText(location);
                    }
                }
            }
        });
    }

    private void createUseDefaultsEditor(Composite mainComposite) {
        Composite group = SWTFactory.createComposite((Composite)mainComposite, (int)2, (int)1, (int)768);
        this.useDefaultCheckBox = SWTFactory.createCheckButton((Composite)group, (String)Messages.NpmInitWizard_UseDefaulConfiguration, null, (boolean)true, (int)2);
        this.useDefaultCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefault = ((Button)e.widget).getSelection();
                NpmInitPage.this.nameText.setEnabled(!useDefault);
                NpmInitPage.this.versionText.setEnabled(!useDefault);
                NpmInitPage.this.descriptionText.setEnabled(!useDefault);
                NpmInitPage.this.mainText.setEnabled(!useDefault);
                NpmInitPage.this.authorText.setEnabled(!useDefault);
                NpmInitPage.this.licenseText.setEnabled(!useDefault);
                NpmInitPage.this.scriptsTable.setEnabled(!useDefault);
                NpmInitPage.this.addScriptButton.setEnabled(!useDefault);
                if (useDefault) {
                    NpmInitPage.this.setDefaults();
                } else {
                    NpmInitPage.this.nameText.setEnabled(true);
                    NpmInitPage.this.versionText.setEnabled(true);
                    NpmInitPage.this.descriptionText.setEnabled(true);
                    NpmInitPage.this.mainText.setEnabled(true);
                    NpmInitPage.this.authorText.setEnabled(true);
                    NpmInitPage.this.licenseText.setEnabled(true);
                    NpmInitPage.this.scriptsTable.setEnabled(true);
                    NpmInitPage.this.addScriptButton.setEnabled(true);
                }
            }
        });
    }

    private void createBasePropertyEditor(Composite mainComposite) {
        Group group = SWTFactory.createGroup((Composite)mainComposite, (String)Messages.NpmInitWizard_Properties, (int)2, (int)1, (int)768);
        Label nameLabel = new Label((Composite)group, 0);
        nameLabel.setText(Messages.NpmInitWizard_Name);
        this.nameText = new Text((Composite)group, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.nameText.addModifyListener((ModifyListener)new EntriesChangedListener());
        Label versionLabel = new Label((Composite)group, 0);
        versionLabel.setText(Messages.NpmInitWizard_Version);
        this.versionText = new Text((Composite)group, 2048);
        this.versionText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.versionText.addModifyListener((ModifyListener)new EntriesChangedListener());
        Label descriptionLabel = new Label((Composite)group, 0);
        descriptionLabel.setText(Messages.NpmInitWizard_Description);
        this.descriptionText = new Text((Composite)group, 2048);
        this.descriptionText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.descriptionText.addModifyListener((ModifyListener)new EntriesChangedListener());
        Label mainLabel = new Label((Composite)group, 0);
        mainLabel.setText(Messages.NpmInitWizard_Main);
        this.mainText = new Text((Composite)group, 2048);
        this.mainText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mainText.addModifyListener((ModifyListener)new EntriesChangedListener());
        Label authorLabel = new Label((Composite)group, 0);
        authorLabel.setText(Messages.NpmInitWizard_Author);
        this.authorText = new Text((Composite)group, 2048);
        this.authorText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.authorText.addModifyListener((ModifyListener)new EntriesChangedListener());
        Label licenseLabel = new Label((Composite)group, 0);
        licenseLabel.setText(Messages.NpmInitWizard_License);
        this.licenseText = new Text((Composite)group, 2048);
        this.licenseText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.licenseText.addModifyListener((ModifyListener)new EntriesChangedListener());
    }

    private void createScriptsEditor(Composite mainComposite) {
        TableGroupComposite scriptsComposite = new TableGroupComposite(Messages.NpmInitWizard_Scripts, Messages.NpmInitWizard_ScriptPopUpName, Messages.NpmInitWizard_ScriptPopUpValue, mainComposite, Messages.NpmInitWizard_AddScript, Messages.NpmInitWizard_EditScript);
        scriptsComposite.createControls();
        this.scriptsTable = scriptsComposite.getTable();
        this.addScriptButton = scriptsComposite.getAddButton();
    }

    public String getName() {
        return Messages.NpmInitWizard_LaunchMainTabName;
    }

    private Map<String, String> getKeyValueItems(Table table) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        TableItem[] items = table.getItems();
        if (items != null && items.length > 0) {
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                map.put(item.getText(0), item.getText(1));
                ++n2;
            }
        }
        return map;
    }

    private void setDefaults(Table table, Map<String, String> defaultItems) {
        if (table != null && defaultItems != null && !defaultItems.isEmpty()) {
            table.removeAll();
            for (Map.Entry<String, String> entry : defaultItems.entrySet()) {
                TableItem item = new TableItem(table, 0);
                item.setText(0, entry.getKey());
                item.setText(1, entry.getValue());
            }
        }
    }

    private void setDefaults() {
        this.nameText.setText(this.defaultName);
        this.versionText.setText(this.defaultVersion);
        this.descriptionText.setText(this.defaultDescription);
        this.mainText.setText(this.defaultMain);
        this.authorText.setText(this.defaultAuthor);
        this.licenseText.setText(this.defaultLicense);
        this.setDefaults(this.scriptsTable, this.defaultScripts);
    }

    private void entriesChanged() {
        String dir = this.dirText.getText();
        if (dir == null || dir.isEmpty()) {
            this.setPageComplete(false);
            this.setErrorMessage(Messages.NpmInitWizard_ErrorDirNotDefiened);
        } else {
            IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(dir));
            if (container != null && container.exists()) {
                IFile packageJson = container.getFile((IPath)new Path("package.json"));
                if (packageJson.exists()) {
                    this.setError(Messages.NpmInitWizard_ErrorPackageJsonAlreadyExist);
                } else {
                    this.setComplete();
                }
            } else {
                this.setError(Messages.NpmInitWizard_ErrorDirNotExist);
            }
        }
    }

    private void setError(String message) {
        this.setPageComplete(false);
        this.setErrorMessage(message);
    }

    private void setComplete() {
        this.setPageComplete(true);
        this.setErrorMessage(null);
    }

    private class EntriesChangedListener
    implements ModifyListener,
    SelectionListener {
        private EntriesChangedListener() {
        }

        public void modifyText(ModifyEvent e) {
            NpmInitPage.this.entriesChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            NpmInitPage.this.entriesChanged();
        }

        public void widgetSelected(SelectionEvent e) {
            NpmInitPage.this.entriesChanged();
        }
    }

    private class TableGroupComposite {
        private String groupLabel;
        private String keyLabel;
        private String valueLabel;
        private Composite parent;
        private Table table;
        private Button addButton;
        private Button editButton;
        private Button removeButton;
        private String addDialogTitle;
        private String editDialogTitle;

        public TableGroupComposite(String groupLabel, String keyLabel, String valueLabel, Composite parent, String addDialogTitle, String editDialogTitle) {
            this.groupLabel = groupLabel;
            this.keyLabel = keyLabel;
            this.valueLabel = valueLabel;
            this.parent = parent;
            this.addDialogTitle = addDialogTitle;
            this.editDialogTitle = editDialogTitle;
        }

        public Table getTable() {
            return this.table;
        }

        public Button getAddButton() {
            return this.addButton;
        }

        public void createControls() {
            Group tableGroup = SWTFactory.createGroup((Composite)this.parent, (String)this.groupLabel, (int)2, (int)1, (int)768);
            TableViewer tableViewer = new TableViewer((Composite)tableGroup, 67586);
            tableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    TableItem[] selection = TableGroupComposite.this.table.getSelection();
                    if (selection.length == 1) {
                        TableGroupComposite.this.editProperty(TableGroupComposite.this.editDialogTitle, selection[0].getText(0), selection[0].getText(1));
                    }
                }
            });
            tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    TableItem[] items = TableGroupComposite.this.table.getSelection();
                    if (items == null || items.length == 0) {
                        TableGroupComposite.this.editButton.setEnabled(false);
                        TableGroupComposite.this.removeButton.setEnabled(false);
                    } else if (items.length == 1) {
                        TableGroupComposite.this.editButton.setEnabled(true);
                        TableGroupComposite.this.removeButton.setEnabled(true);
                    } else {
                        TableGroupComposite.this.editButton.setEnabled(false);
                        TableGroupComposite.this.removeButton.setEnabled(true);
                    }
                }
            });
            this.table = tableViewer.getTable();
            GridData data = new GridData(4, 4, true, true);
            data.heightHint = 50;
            this.table.setLayoutData((Object)data);
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            TableColumn propColumn = new TableColumn(this.table, 0, 0);
            propColumn.setWidth(120);
            propColumn.setText(Messages.NpmInitWizard_ScriptName);
            TableColumn valueColumn = new TableColumn(this.table, 0, 1);
            valueColumn.setWidth(250);
            valueColumn.setText(Messages.NpmInitWizard_ScriptValue);
            Composite buttonComposite = new Composite((Composite)tableGroup, 0);
            FillLayout fillLayout = new FillLayout(512);
            fillLayout.spacing = 2;
            buttonComposite.setLayout((Layout)fillLayout);
            this.addButton = new Button(buttonComposite, 0);
            this.addButton.setText(Messages.NpmInitWizard_ButtonAdd);
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableGroupComposite.this.addProperty(TableGroupComposite.this.addDialogTitle);
                }
            });
            this.editButton = new Button(buttonComposite, 0);
            this.editButton.setText(Messages.NpmInitWizard_ButtonEdit);
            this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableItem[] selection;
                    if (TableGroupComposite.this.table.getSelectionCount() > 0 && (selection = TableGroupComposite.this.table.getSelection()).length == 1) {
                        TableGroupComposite.this.editProperty(TableGroupComposite.this.editDialogTitle, selection[0].getText(0), selection[0].getText(1));
                    }
                }
            });
            this.editButton.setEnabled(false);
            this.removeButton = new Button(buttonComposite, 0);
            this.removeButton.setText(Messages.NpmInitWizard_ButtonRemove);
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (TableGroupComposite.this.table.getSelectionCount() > 0) {
                        TableGroupComposite.this.table.remove(TableGroupComposite.this.table.getSelectionIndices());
                    }
                }
            });
            this.removeButton.setEnabled(false);
        }

        private void addProperty(String title) {
            PopUpKeyValueDialog dialog = new PopUpKeyValueDialog(NpmInitPage.this.getShell(), title, "", "", this.keyLabel, this.valueLabel, null);
            if (dialog.open() == 0) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(0, dialog.getKey());
                item.setText(1, dialog.getValue());
                NpmInitPage.this.entriesChanged();
            }
        }

        private void editProperty(String title, String name, String value) {
            PopUpKeyValueDialog dialog = new PopUpKeyValueDialog(NpmInitPage.this.getShell(), title, name, value, this.keyLabel, this.valueLabel, null);
            if (dialog.open() == 0) {
                TableItem[] item = this.table.getSelection();
                item[0].setText(0, dialog.getKey());
                item[0].setText(1, dialog.getValue());
                NpmInitPage.this.entriesChanged();
            }
        }
    }
}

