/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.editors;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.wst.jsdt.chromium.JsEvaluateContext;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.debug.core.model.EvaluateContext;
import org.eclipse.wst.jsdt.chromium.debug.core.util.JsValueStringifier;
import org.eclipse.wst.jsdt.chromium.debug.ui.editors.JavascriptUtil;

public class JsDebugTextHover
implements ITextHover {
    private static final JsValueStringifier STRINGIFIER = new JsValueStringifier();

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IDocument doc = textViewer.getDocument();
        String expression = JavascriptUtil.extractSurroundingJsIdentifier(doc, hoverRegion.getOffset());
        if (expression == null) {
            return null;
        }
        IAdaptable context = DebugUITools.getDebugContext();
        if (context == null) {
            return null;
        }
        EvaluateContext evaluateContext = (EvaluateContext)context.getAdapter(EvaluateContext.class);
        if (evaluateContext == null) {
            return null;
        }
        final JsValue[] result = new JsValue[1];
        evaluateContext.getJsEvaluateContext().evaluateSync(expression, null, new JsEvaluateContext.EvaluateCallback(){

            public void success(JsEvaluateContext.ResultOrException valueOrException) {
                result[0] = (JsValue)valueOrException.accept((JsEvaluateContext.ResultOrException.Visitor)new JsEvaluateContext.ResultOrException.Visitor<JsValue>(){

                    public JsValue visitResult(JsValue value) {
                        return value;
                    }

                    public JsValue visitException(JsValue exception) {
                        return null;
                    }
                });
            }

            public void failure(Exception cause) {
            }
        });
        if (result[0] == null) {
            return null;
        }
        return STRINGIFIER.render(result[0]);
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        IDocument doc = textViewer.getDocument();
        return JavascriptUtil.getSurroundingIdentifierRegion(doc, offset, false);
    }
}

