/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import org.eclipse.wst.jsdt.chromium.debug.core.ScriptNameManipulator;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResourceId;

public abstract class VmResourceRef {
    public static VmResourceRef forRegExpBased(ScriptNameManipulator.ScriptNamePattern scriptNamePattern) {
        return new ForRegExpBased(scriptNamePattern);
    }

    public static VmResourceRef forVmResourceId(VmResourceId vmResourceId) {
        return new ForVmResourceId(vmResourceId);
    }

    public abstract <R> R accept(Visitor<R> var1);

    private static final class ForRegExpBased
    extends VmResourceRef {
        private final ScriptNameManipulator.ScriptNamePattern scriptNamePattern;

        ForRegExpBased(ScriptNameManipulator.ScriptNamePattern scriptNamePattern) {
            this.scriptNamePattern = scriptNamePattern;
        }

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visitRegExpBased(this.scriptNamePattern);
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ForRegExpBased that = (ForRegExpBased)obj;
            return this.scriptNamePattern.getJavaScriptRegExp().equals(that.scriptNamePattern.getJavaScriptRegExp());
        }

        public int hashCode() {
            return this.scriptNamePattern.getJavaScriptRegExp().hashCode();
        }
    }

    private static final class ForVmResourceId
    extends VmResourceRef {
        private final VmResourceId vmResourceId;

        ForVmResourceId(VmResourceId vmResourceId) {
            this.vmResourceId = vmResourceId;
        }

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visitResourceId(this.vmResourceId);
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ForVmResourceId that = (ForVmResourceId)obj;
            return this.vmResourceId.equals(that.vmResourceId);
        }

        public int hashCode() {
            return this.vmResourceId.hashCode();
        }
    }

    public static interface Visitor<R> {
        public R visitRegExpBased(ScriptNameManipulator.ScriptNamePattern var1);

        public R visitResourceId(VmResourceId var1);
    }
}

