/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.ui.palette.customize.DrawerEntryPage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.wst.common.snippets.core.ISnippetsEntry;
import org.eclipse.wst.common.snippets.internal.SnippetsMessages;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteDrawer;
import org.eclipse.wst.common.snippets.internal.util.VisibilityUtil;

public class SnippetDrawerEntryPage
extends DrawerEntryPage {
    protected Button fAlwaysHideButton;
    protected Button fAlwaysShowButton;
    protected Button fBrowseButton;
    protected Object[] fContentTypes = new Object[0];
    protected Table fContentTypeTable = null;
    protected Text fContentTypeText;
    protected Button fCustomButton;
    protected Table fFileTypeTable = null;
    protected List fFileTypeTableItems = new ArrayList();
    protected List fImagesToDispose = new ArrayList();

    protected void browsePressed() {
        String firstFilter;
        ListSelectionDialog dialog = new ListSelectionDialog(this.getControl().getShell(), (Object)Platform.getContentTypeManager(), (IStructuredContentProvider)new ContentTypeStructuredContentProvider(), (ILabelProvider)new ContentTypeLabelProvider(), null);
        dialog.setTitle(SnippetsMessages.SnippetDrawerEntryPage_5);
        dialog.setMessage(SnippetsMessages.SnippetDrawerEntryPage_6);
        ArrayList<IContentType> initialSelections = new ArrayList<IContentType>();
        IContentType[] contentTypes = Platform.getContentTypeManager().getAllContentTypes();
        ISnippetsEntry snippetEntry = (ISnippetsEntry)this.getEntry();
        String[] filters = snippetEntry.getFilters();
        IContentTypeManager manager = Platform.getContentTypeManager();
        if (filters.length >= 1 && (firstFilter = filters[0]).compareTo("-") != 0) {
            if (firstFilter.compareTo("*") == 0) {
                int i = 0;
                while (i < contentTypes.length) {
                    initialSelections.add(contentTypes[i]);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < contentTypes.length) {
                    int j = 0;
                    while (j < filters.length) {
                        IContentType filterContentType = manager.getContentType(filters[j]);
                        if (filterContentType != null && contentTypes[i].getName().compareTo(filterContentType.getName()) == 0) {
                            initialSelections.add(contentTypes[i]);
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        dialog.setInitialSelections(initialSelections.toArray());
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.wst.common.snippets.snip0030");
        if (dialog.open() == 0) {
            this.fContentTypes = dialog.getResult();
            this.refreshContentTypeText();
            this.refreshEntryFilters();
        }
    }

    protected Composite createContentTypeRadios(Composite panel) {
        Composite radioGroup = new Composite(panel, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        radioGroup.setLayout((Layout)layout);
        GridData radioGroupGridData = new GridData(768);
        radioGroupGridData.horizontalIndent = 15;
        radioGroup.setLayoutData((Object)radioGroupGridData);
        SelectionAdapter updateEnablement = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnippetDrawerEntryPage.this.updateEnablement();
                SnippetDrawerEntryPage.this.refreshEntryFilters();
            }
        };
        this.fAlwaysShowButton = new Button(radioGroup, 16);
        this.fAlwaysShowButton.setText(SnippetsMessages.SnippetDrawerEntryPage_1);
        this.fAlwaysShowButton.setSelection(true);
        this.fAlwaysShowButton.addSelectionListener((SelectionListener)updateEnablement);
        this.fAlwaysHideButton = new Button(radioGroup, 16);
        this.fAlwaysHideButton.setText(SnippetsMessages.SnippetDrawerEntryPage_2);
        this.fAlwaysHideButton.addSelectionListener((SelectionListener)updateEnablement);
        this.fCustomButton = new Button(radioGroup, 16);
        this.fCustomButton.setText(SnippetsMessages.SnippetDrawerEntryPage_3);
        this.fCustomButton.addSelectionListener((SelectionListener)updateEnablement);
        return radioGroup;
    }

    protected Composite createContentTypeTextRow(Composite panel) {
        Composite contentTypeTextRow = new Composite(panel, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        contentTypeTextRow.setLayout((Layout)layout);
        GridData contentTypeTextRowGridData = new GridData(768);
        contentTypeTextRowGridData.horizontalIndent = 33;
        contentTypeTextRowGridData.widthHint = 0;
        contentTypeTextRow.setLayoutData((Object)contentTypeTextRowGridData);
        this.fContentTypeText = new Text(contentTypeTextRow, 2060);
        this.fContentTypeText.setEnabled(false);
        GridData contentTypeTextGridData = new GridData(768);
        this.fContentTypeText.setLayoutData((Object)contentTypeTextGridData);
        this.fBrowseButton = new Button(contentTypeTextRow, 8);
        this.fBrowseButton.setText(SnippetsMessages.SnippetDrawerEntryPage_4);
        this.fBrowseButton.setEnabled(false);
        GridData browseButtonGridData = new GridData(256);
        this.fBrowseButton.setLayoutData((Object)browseButtonGridData);
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnippetDrawerEntryPage.this.browsePressed();
            }
        });
        return contentTypeTextRow;
    }

    public void createControl(Composite parent, PaletteEntry entry) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.wst.common.snippets.libv1300");
        super.createControl(parent, entry);
        Composite panel = (Composite)this.getControl();
        Control[] tablist = new Control[panel.getTabList().length + 2];
        System.arraycopy(panel.getTabList(), 0, tablist, 0, tablist.length - 2);
        this.createLabel(panel, 0, SnippetsMessages.SnippetDrawerEntryPage_0);
        tablist[tablist.length - 2] = this.createContentTypeRadios(panel);
        tablist[tablist.length - 1] = this.createContentTypeTextRow(panel);
        this.initContentTypeOption();
        panel.setTabList(tablist);
        panel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SnippetDrawerEntryPage.this.fImagesToDispose != null) {
                    Iterator iterator = SnippetDrawerEntryPage.this.fImagesToDispose.iterator();
                    while (iterator.hasNext()) {
                        ((Image)iterator.next()).dispose();
                    }
                    SnippetDrawerEntryPage.this.fImagesToDispose = null;
                }
            }
        });
    }

    protected void initContentTypeOption() {
        ISnippetsEntry snippetEntry = (ISnippetsEntry)this.getEntry();
        String[] filters = snippetEntry.getFilters();
        if (filters == null) {
            this.fAlwaysShowButton.setSelection(true);
        } else if (filters.length >= 1) {
            String firstFilter = filters[0];
            if (firstFilter.compareTo("*") == 0) {
                this.fAlwaysShowButton.setSelection(true);
                this.fAlwaysHideButton.setSelection(false);
                this.fCustomButton.setSelection(false);
                this.fContentTypeText.setEnabled(false);
                this.fBrowseButton.setEnabled(false);
                this.fContentTypeText.setText("");
            } else if (firstFilter.compareTo("!") == 0) {
                this.fAlwaysShowButton.setSelection(false);
                this.fAlwaysHideButton.setSelection(true);
                this.fCustomButton.setSelection(false);
                this.fContentTypeText.setEnabled(false);
                this.fBrowseButton.setEnabled(false);
                this.fContentTypeText.setText("");
            } else if (firstFilter.compareTo("-") == 0) {
                this.fAlwaysShowButton.setSelection(false);
                this.fAlwaysHideButton.setSelection(false);
                this.fCustomButton.setSelection(true);
                this.fContentTypeText.setEnabled(true);
                this.fBrowseButton.setEnabled(true);
                this.fContentTypeText.setText("");
            } else {
                this.fAlwaysShowButton.setSelection(false);
                this.fAlwaysHideButton.setSelection(false);
                this.fCustomButton.setSelection(true);
                this.fContentTypeText.setEnabled(true);
                this.fBrowseButton.setEnabled(true);
                IContentTypeManager manager = Platform.getContentTypeManager();
                String text = "";
                int i = 0;
                while (i < filters.length) {
                    IContentType contentType = manager.getContentType(filters[i]);
                    if (contentType != null) {
                        if (text.length() > 0) {
                            text = String.valueOf(text) + ",";
                        }
                        text = String.valueOf(text) + contentType.getName();
                    }
                    ++i;
                }
                this.fContentTypeText.setText(text);
            }
        }
    }

    protected void refreshContentTypeText() {
        switch (this.fContentTypes.length) {
            case 0: {
                this.fContentTypeText.setText("");
                break;
            }
            case 1: {
                this.fContentTypeText.setText(((IContentType)this.fContentTypes[0]).getName());
                break;
            }
            default: {
                String text = "";
                int i = 0;
                while (i < this.fContentTypes.length) {
                    if (text.length() > 0) {
                        text = String.valueOf(text) + ",";
                    }
                    text = String.valueOf(text) + ((IContentType)this.fContentTypes[i]).getName();
                    ++i;
                }
                this.fContentTypeText.setText(text);
            }
        }
    }

    protected void refreshEntryFilters() {
        SnippetPaletteDrawer snippetDrawer = (SnippetPaletteDrawer)this.getEntry();
        if (this.fAlwaysShowButton.getSelection()) {
            snippetDrawer.setFilters(new String[]{"*"});
            snippetDrawer.setVisible(true);
        } else if (this.fAlwaysHideButton.getSelection()) {
            snippetDrawer.setFilters(new String[]{"!"});
            snippetDrawer.setVisible(false);
        } else if (this.fContentTypes.length == 0) {
            snippetDrawer.setFilters(new String[]{"-"});
            snippetDrawer.setVisible(false);
        } else {
            String[] filters = new String[this.fContentTypes.length];
            int i = 0;
            while (i < this.fContentTypes.length) {
                filters[i] = ((IContentType)this.fContentTypes[i]).getId();
                ++i;
            }
            boolean visible = false;
            IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (activeEditor == null) {
                visible = true;
            } else {
                IEditorInput input = activeEditor.getEditorInput();
                visible = VisibilityUtil.isContentType(input, filters);
            }
            snippetDrawer.setFilters(filters);
            snippetDrawer.setVisible(visible);
        }
    }

    protected void updateEnablement() {
        if (this.fAlwaysShowButton.getSelection()) {
            this.fAlwaysShowButton.setSelection(true);
            this.fAlwaysHideButton.setSelection(false);
            this.fCustomButton.setSelection(false);
            this.fContentTypeText.setEnabled(false);
            this.fBrowseButton.setEnabled(false);
            this.fContentTypeText.setText("");
        } else if (this.fAlwaysHideButton.getSelection()) {
            this.fAlwaysShowButton.setSelection(false);
            this.fAlwaysHideButton.setSelection(true);
            this.fCustomButton.setSelection(false);
            this.fContentTypeText.setEnabled(false);
            this.fBrowseButton.setEnabled(false);
            this.fContentTypeText.setText("");
        } else {
            this.fAlwaysShowButton.setSelection(false);
            this.fAlwaysHideButton.setSelection(false);
            this.fCustomButton.setSelection(true);
            this.fContentTypeText.setEnabled(true);
            this.fBrowseButton.setEnabled(true);
            this.refreshContentTypeText();
        }
    }

    protected void handleNameChanged(String text) {
        super.handleNameChanged(text);
        if (text.length() < 1) {
            this.getPageContainer().showProblem(SnippetsMessages.NameCannotBeEmpty);
        } else {
            this.getPageContainer().clearProblem();
        }
    }

    class ContentTypeLabelProvider
    implements ILabelProvider {
        ContentTypeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            String text = "";
            if (element != null && element instanceof IContentType) {
                text = ((IContentType)element).getName();
            }
            return text;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class ContentTypeSelectionDialog
    extends ElementListSelectionDialog {
        public ContentTypeSelectionDialog(Shell parent, ILabelProvider renderer) {
            super(parent, renderer);
        }
    }

    class ContentTypeStructuredContentProvider
    implements IStructuredContentProvider {
        ContentTypeStructuredContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            IContentTypeManager manager = Platform.getContentTypeManager();
            Object[] contentTypes = manager.getAllContentTypes();
            Arrays.sort(contentTypes, new Comparator(this){
                final /* synthetic */ ContentTypeStructuredContentProvider this$1;
                {
                    this.this$1 = contentTypeStructuredContentProvider;
                }

                public int compare(Object arg0, Object arg1) {
                    return ((IContentType)arg0).getName().compareTo(((IContentType)arg1).getName());
                }
            });
            return contentTypes;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

