/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Insets;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.AbsoluteBasedLayoutEditPolicy;
import org.eclipse.wb.internal.core.laf.BaselineSupportHelper;
import org.eclipse.wb.internal.swt.gef.ControlsLayoutRequestValidator;
import org.eclipse.wb.internal.swt.model.layout.ILayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.ICompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsoluteBasedLayoutEditPolicySWT<C extends IControlInfo>
extends AbsoluteBasedLayoutEditPolicy<C> {
    private final ILayoutInfo<C> m_layout;

    public AbsoluteBasedLayoutEditPolicySWT(ILayoutInfo<C> layout) {
        super(layout.getUnderlyingModel());
        this.m_layout = layout;
    }

    protected ILayoutRequestValidator getRequestValidator() {
        return ControlsLayoutRequestValidator.INSTANCE;
    }

    public List<C> getAllComponents() {
        ArrayList components = Lists.newArrayList();
        components.addAll(this.m_layout.getControls());
        return components;
    }

    public int getBaseline(IAbstractComponentInfo component) {
        return BaselineSupportHelper.getBaseline((Object)component.getObject());
    }

    public Dimension getComponentPreferredSize(IAbstractComponentInfo component) {
        IControlInfo componentInfo = (IControlInfo)component;
        return componentInfo.getPreferredSize();
    }

    public Dimension getContainerSize() {
        ICompositeInfo composite = this.m_layout.getComposite();
        Rectangle compositeBounds = composite.getModelBounds().getCopy();
        Insets clientAreaInsets = composite.getClientAreaInsets();
        return compositeBounds.crop(clientAreaInsets).getSize();
    }
}

