/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.generic;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.model.description.IComponentDescription;
import org.eclipse.wb.internal.core.model.generic.ContainerObjectValidator;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.state.IDescriptionHelper;
import org.eclipse.wb.internal.core.utils.state.ILayoutRequestValidatorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContainerObjectValidators {
    private static final String DEF_functions = StringUtils.join((Object[])new String[]{"def isModelType(model, c) {", "  if (c is String) {", "    return ReflectionUtils.isSuccessorOf((Class) model.description.componentClass, c);", "  } else {", "    return c.isAssignableFrom(model.description.componentClass);", "  }", "};", "def isSuccessorOf(o, c) {", "  if (c is String) {", "    return ReflectionUtils.isSuccessorOf(o, c);", "  } else {", "    return o != null && c.isAssignableFrom(o.getClass());", "  }", "};", "def isComponentType(c) {", "  return isModelType(component, c);", "};", "def isReferenceType(c) {", "  return isModelType(reference, c);", "};", "def isContainerType(c) {", "  return isModelType(container, c);", "};", "def isContainerThis() {", "  return isSuccessorOf(container.creationSupport, 'org.eclipse.wb.internal.core.model.creation.ThisCreationSupport');", "};"}, (String)"\n");

    public static ContainerObjectValidator alwaysTrue() {
        return new ContainerObjectValidator(){

            public boolean validate(Object container, Object object) {
                return true;
            }

            public String toString() {
                return "alwaysTrue";
            }
        };
    }

    public static ContainerObjectValidator forList(final String[] types) {
        return new ContainerObjectValidator(){

            public boolean validate(Object container, Object object) {
                ILayoutRequestValidatorHelper validatorHelper = GlobalState.getValidatorHelper();
                if (validatorHelper.isComponent(object)) {
                    IDescriptionHelper descriptionHelper = GlobalState.getDescriptionHelper();
                    IComponentDescription description = descriptionHelper.getDescription(object);
                    Class<?> componentClass = description.getComponentClass();
                    String[] stringArray = types;
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String type = stringArray[n2];
                        if (ReflectionUtils.isSuccessorOf(componentClass, type)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                return false;
            }

            public String toString() {
                return StringUtils.join((Object[])types, (String)" ");
            }
        };
    }

    public static ContainerObjectValidator forComponentExpression(final String expression) {
        return new ContainerObjectValidator(){

            public boolean validate(Object container, Object component) {
                ILayoutRequestValidatorHelper validatorHelper = GlobalState.getValidatorHelper();
                if (validatorHelper.isComponent(container) && validatorHelper.isComponent(component)) {
                    TreeMap variables = Maps.newTreeMap();
                    variables.put("container", container);
                    variables.put("component", component);
                    return ContainerObjectValidators.evaluate(expression, variables);
                }
                return false;
            }

            public String toString() {
                return expression;
            }
        };
    }

    public static ContainerObjectValidator forReferenceExpression(final String expression) {
        return new ContainerObjectValidator(){

            public boolean validate(Object container, Object reference) {
                ILayoutRequestValidatorHelper validatorHelper = GlobalState.getValidatorHelper();
                if (validatorHelper.isComponent(container) && validatorHelper.isComponent(reference)) {
                    TreeMap variables = Maps.newTreeMap();
                    variables.put("container", container);
                    variables.put("reference", reference);
                    return ContainerObjectValidators.evaluate(expression, variables);
                }
                return false;
            }

            public String toString() {
                return expression;
            }
        };
    }

    public static boolean validateContainer(Object container, String expression) {
        return ContainerObjectValidators.validateContainer(expression, container);
    }

    private static boolean validateContainer(String expression, Object container) {
        TreeMap variables = Maps.newTreeMap();
        variables.put("container", container);
        return ContainerObjectValidators.evaluate(expression, variables);
    }

    public static Predicate<Object> forContainerExpression(final String expression) {
        return new Predicate<Object>(){

            public boolean apply(Object container) {
                ILayoutRequestValidatorHelper validatorHelper = GlobalState.getValidatorHelper();
                if (validatorHelper.isComponent(container)) {
                    return ContainerObjectValidators.validateContainer(expression, container);
                }
                return false;
            }

            public String toString() {
                return expression;
            }
        };
    }

    private static boolean evaluate(String expression, Map<String, Object> variables) {
        String e = String.valueOf(DEF_functions) + expression;
        return (Boolean)ScriptUtils.evaluate(e, variables);
    }
}

