/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.internal.engine;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;

public abstract class ListenerContainer<Listener> {
    protected final Set<Listener> listeners = new HashSet<Listener>();

    public synchronized void addListener(Listener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"Cannot add null listener!");
        boolean added = this.listeners.add(listener);
        if (added) {
            this.listenerAdded(listener);
        }
    }

    public synchronized void removeListener(Listener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"Cannot remove null listener!");
        boolean removed = this.listeners.remove(listener);
        if (removed) {
            this.listenerRemoved(listener);
        }
    }

    protected abstract void listenerAdded(Listener var1);

    protected abstract void listenerRemoved(Listener var1);
}

