/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.api;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.viatra.query.runtime.api.IQueryGroup;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.impl.BaseQueryGroup;
import org.eclipse.viatra.query.runtime.matchers.util.IProvider;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public class LazyLoadingQueryGroup
extends BaseQueryGroup {
    private final Set<? extends IProvider<IQuerySpecification<?>>> providers;
    private Set<IQuerySpecification<?>> specifications = null;

    public LazyLoadingQueryGroup(Set<? extends IProvider<IQuerySpecification<?>>> providers) {
        Preconditions.checkArgument((providers != null ? 1 : 0) != 0, (Object)"The set of providers must not be null");
        this.providers = providers;
    }

    public static IQueryGroup of(Set<? extends IProvider<IQuerySpecification<?>>> querySpecifications) {
        return new LazyLoadingQueryGroup(querySpecifications);
    }

    @Override
    public Set<IQuerySpecification<?>> getSpecifications() {
        if (this.specifications == null) {
            this.specifications = Sets.newHashSet((Iterable)Iterables.filter((Iterable)Iterables.transform(this.providers, (Function)new Function<IProvider<IQuerySpecification<?>>, IQuerySpecification<?>>(){

                public IQuerySpecification<?> apply(IProvider<IQuerySpecification<?>> input) {
                    if (input == null) {
                        return null;
                    }
                    try {
                        return (IQuerySpecification)input.get();
                    }
                    catch (Exception e) {
                        String errorMessage = "Exception occurred while accessing query specification from provider: " + e.getMessage();
                        ViatraQueryLoggingUtil.getLogger(this.getClass()).error((Object)errorMessage);
                        return null;
                    }
                }
            }), (Predicate)Predicates.notNull()));
        }
        return this.specifications;
    }
}

