/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.planning.helpers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.psystem.ITypeInfoProviderConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.TypeJudgement;

public class TypeHelper {
    public static Map<PVariable, Set<IInputKey>> inferUnaryTypesFor(Iterable<PVariable> variables, Set<PConstraint> constraints, IQueryMetaContext context) {
        Map<PVariable, Set<TypeJudgement>> typeMap = TypeHelper.inferUnaryTypes(constraints, context);
        return TypeHelper.inferUnaryTypesFor(variables, typeMap);
    }

    public static Map<PVariable, Set<IInputKey>> inferUnaryTypesFor(Iterable<PVariable> variables, Map<PVariable, Set<TypeJudgement>> typeMap) {
        HashMap<PVariable, Set<IInputKey>> result = new HashMap<PVariable, Set<IInputKey>>();
        for (PVariable original : variables) {
            HashSet<IInputKey> keys = new HashSet<IInputKey>();
            PVariable current = original;
            while (current != null) {
                Set<TypeJudgement> judgements = typeMap.get(current);
                if (judgements != null) {
                    for (TypeJudgement judgement : judgements) {
                        keys.add(judgement.getInputKey());
                    }
                }
                current = current.getDirectUnifiedInto();
            }
            result.put(original, keys);
        }
        return result;
    }

    public static Map<PVariable, Set<TypeJudgement>> inferUnaryTypes(Set<PConstraint> constraints, IQueryMetaContext context) {
        Set<TypeJudgement> equivalentJudgements = TypeHelper.getDirectJudgements(constraints, context);
        Set<TypeJudgement> impliedJudgements = TypeHelper.typeClosure(equivalentJudgements, context);
        HashMap<PVariable, Set<TypeJudgement>> results = new HashMap<PVariable, Set<TypeJudgement>>();
        for (TypeJudgement typeJudgement : impliedJudgements) {
            IInputKey inputKey = typeJudgement.getInputKey();
            if (inputKey.getArity() != 1) continue;
            PVariable variable = (PVariable)typeJudgement.getVariablesTuple().get(0);
            HashSet<TypeJudgement> inferredTypes = (HashSet<TypeJudgement>)results.get(variable);
            if (inferredTypes == null) {
                inferredTypes = new HashSet<TypeJudgement>();
                results.put(variable, inferredTypes);
            }
            inferredTypes.add(typeJudgement);
        }
        return results;
    }

    public static Set<TypeJudgement> getDirectJudgements(Set<PConstraint> constraints, IQueryMetaContext context) {
        HashSet<TypeJudgement> equivalentJudgements = new HashSet<TypeJudgement>();
        for (PConstraint pConstraint : constraints) {
            if (!(pConstraint instanceof ITypeInfoProviderConstraint)) continue;
            equivalentJudgements.addAll(((ITypeInfoProviderConstraint)pConstraint).getImpliedJudgements(context));
        }
        return equivalentJudgements;
    }

    public static Set<TypeJudgement> typeClosure(Set<TypeJudgement> typesToClose, IQueryMetaContext context) {
        return TypeHelper.typeClosure(Collections.emptySet(), typesToClose, context);
    }

    public static Set<TypeJudgement> typeClosure(Set<TypeJudgement> preclosedBaseSet, Set<TypeJudgement> delta, IQueryMetaContext context) {
        if ((delta = Sets.difference(delta, preclosedBaseSet)).isEmpty()) {
            return preclosedBaseSet;
        }
        HashSet<TypeJudgement> closure = new HashSet<TypeJudgement>(preclosedBaseSet);
        LinkedList<TypeJudgement> queue = new LinkedList<TypeJudgement>((Collection<TypeJudgement>)delta);
        HashMultimap conditionalImplications = HashMultimap.create();
        for (TypeJudgement typeJudgement : closure) {
            conditionalImplications.putAll(typeJudgement.getConditionalImpliedJudgements(context));
        }
        do {
            TypeJudgement deltaType;
            if (!closure.add(deltaType = (TypeJudgement)queue.poll())) continue;
            queue.addAll(deltaType.getDirectlyImpliedJudgements(context));
            queue.addAll(conditionalImplications.get((Object)deltaType));
            SetMultimap<TypeJudgement, TypeJudgement> deltaConditionalImplications = deltaType.getConditionalImpliedJudgements(context);
            for (TypeJudgement condition : deltaConditionalImplications.keySet()) {
                if (closure.contains(condition)) {
                    queue.addAll(deltaConditionalImplications.get((Object)condition));
                    continue;
                }
                conditionalImplications.putAll((Object)condition, (Iterable)deltaConditionalImplications.get((Object)condition));
            }
        } while (!queue.isEmpty());
        return closure;
    }

    public static Set<TypeJudgement> subsumeTypes(Set<TypeJudgement> subsumableTypes, Set<TypeJudgement> subsumingTypes, IQueryMetaContext context) {
        Set<TypeJudgement> closure = TypeHelper.typeClosure(subsumingTypes, context);
        HashSet<TypeJudgement> subsumed = new HashSet<TypeJudgement>(subsumableTypes);
        subsumed.removeAll(closure);
        return subsumed;
    }
}

