/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.tuple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.LeftInheritanceTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public class TupleMask {
    public final int[] indices;
    public int[] indicesSorted;
    public int sourceWidth;

    public TupleMask(int[] indices, int sourceWidth) {
        this.sourceWidth = sourceWidth;
        this.indices = indices;
        this.indicesSorted = null;
    }

    public static TupleMask linear(int size, int sourceWidth) {
        int[] indices = new int[size];
        int i = 0;
        while (i < size) {
            indices[i] = i;
            ++i;
        }
        return new TupleMask(indices, sourceWidth);
    }

    public static TupleMask identity(int size) {
        return TupleMask.linear(size, size);
    }

    public static TupleMask empty(int sourceWidth) {
        return TupleMask.linear(0, sourceWidth);
    }

    public static TupleMask omit(int omission, int sourceWidth) {
        int size = sourceWidth - 1;
        int[] indices = new int[size];
        int i = 0;
        while (i < omission) {
            indices[i] = i;
            ++i;
        }
        i = omission;
        while (i < size) {
            indices[i] = i + 1;
            ++i;
        }
        return new TupleMask(indices, sourceWidth);
    }

    public TupleMask(boolean[] keep) {
        this.sourceWidth = keep.length;
        int size = 0;
        int k = 0;
        while (k < keep.length) {
            if (keep[k]) {
                ++size;
            }
            ++k;
        }
        this.indices = new int[size];
        int l = 0;
        int k2 = 0;
        while (k2 < keep.length) {
            if (keep[k2]) {
                this.indices[l++] = k2;
            }
            ++k2;
        }
        this.indicesSorted = null;
    }

    public static TupleMask displace(int from, int to, int sourceWidth) {
        int[] indices = new int[sourceWidth];
        int i = 0;
        while (i < sourceWidth) {
            indices[i] = i == to ? from : (i >= from && i < to ? i + 1 : (i > to && i <= from ? i - 1 : i));
            ++i;
        }
        return new TupleMask(indices, sourceWidth);
    }

    public static TupleMask selectSingle(int selected, int sourceWidth) {
        int[] indices = new int[]{selected};
        return new TupleMask(indices, sourceWidth);
    }

    public static TupleMask append(TupleMask left, TupleMask right) {
        int leftLength = left.indices.length;
        int rightLength = right.indices.length;
        int[] indices = new int[leftLength + rightLength];
        int i = 0;
        while (i < leftLength) {
            indices[i] = left.indices[i];
            ++i;
        }
        i = 0;
        while (i < rightLength) {
            indices[i + leftLength] = right.indices[i];
            ++i;
        }
        return new TupleMask(indices, left.sourceWidth);
    }

    public void sort() {
        this.indicesSorted = new int[this.indices.length];
        LinkedList<Integer> list = new LinkedList<Integer>();
        int i = 0;
        while (i < this.indices.length) {
            list.add(this.indices[i]);
            ++i;
        }
        Collections.sort(list);
        i = 0;
        for (Integer a : list) {
            this.indicesSorted[i++] = a;
        }
    }

    public Tuple transform(Tuple original) {
        Object[] signature = new Object[this.indices.length];
        int i = 0;
        while (i < this.indices.length) {
            signature[i] = original.get(this.indices[i]);
            ++i;
        }
        return new FlatTuple(signature);
    }

    public <T> List<T> transform(List<T> original) {
        ArrayList<T> signature = new ArrayList<T>(this.indices.length);
        int i = 0;
        while (i < this.indices.length) {
            signature.add(original.get(this.indices[i]));
            ++i;
        }
        return signature;
    }

    public TupleMask transform(TupleMask mask) {
        int[] cascadeIndices = new int[this.indices.length];
        int i = 0;
        while (i < this.indices.length) {
            cascadeIndices[i] = mask.indices[this.indices[i]];
            ++i;
        }
        return new TupleMask(cascadeIndices, mask.sourceWidth);
    }

    public Tuple combine(Tuple unmasked, Tuple masked, boolean useInheritance, boolean asComplementer) {
        int i;
        int combinedLength;
        int n = combinedLength = asComplementer ? this.indices.length : masked.getSize() - this.indices.length;
        if (!useInheritance) {
            combinedLength += unmasked.getSize();
        }
        Object[] combined = new Object[combinedLength];
        int cPos = 0;
        if (!useInheritance) {
            i = 0;
            while (i < unmasked.getSize()) {
                combined[cPos++] = unmasked.get(i);
                ++i;
            }
        }
        if (asComplementer) {
            i = 0;
            while (i < this.indices.length) {
                combined[cPos++] = masked.get(this.indices[i]);
                ++i;
            }
        } else {
            if (this.indicesSorted == null) {
                this.sort();
            }
            int mPos = 0;
            int i2 = 0;
            while (i2 < masked.getSize()) {
                if (mPos < this.indicesSorted.length && i2 == this.indicesSorted[mPos]) {
                    ++mPos;
                } else {
                    combined[cPos++] = masked.get(i2);
                }
                ++i2;
            }
        }
        return useInheritance ? new LeftInheritanceTuple(unmasked, combined) : new FlatTuple(combined);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = this.sourceWidth;
        int[] nArray = this.indices;
        int n = this.indices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            result = 31 * result + i;
            ++n2;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TupleMask other = (TupleMask)obj;
        if (this.sourceWidth != other.sourceWidth) {
            return false;
        }
        if (this.indices.length != other.indices.length) {
            return false;
        }
        int k = 0;
        while (k < this.indices.length) {
            if (this.indices[k] != other.indices[k]) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("M(" + this.sourceWidth + "->");
        int[] nArray = this.indices;
        int n = this.indices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            s.append(i);
            s.append(',');
            ++n2;
        }
        s.append(')');
        return s.toString();
    }
}

