/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.variables;

import java.util.LinkedHashSet;
import org.eclipse.core.externaltools.internal.model.ExternalToolBuilder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;

public class BuildFilesResolver
implements IDynamicVariableResolver {
    private static final char ARG_REMOVED = 'r';
    private static final char ARG_CHANGED = 'c';
    private static final char ARG_ADDED = 'a';
    private static final char ARG_DIRS = 'd';
    private static final char ARG_FILES = 'f';
    private static final String FILE_LIST_SEPARATOR = " ";

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        String result = null;
        IResourceDelta buildDelta = ExternalToolBuilder.getBuildDelta();
        if (buildDelta != null) {
            final StringBuffer fileList = new StringBuffer();
            final LinkedHashSet changedResources = new LinkedHashSet();
            int deltas = 0;
            boolean dirs = false;
            boolean files = false;
            if (argument != null) {
                if (argument.indexOf(97) > -1) {
                    deltas |= 1;
                }
                if (argument.indexOf(99) > -1) {
                    deltas |= 4;
                }
                if (argument.indexOf(114) > -1) {
                    deltas |= 2;
                }
                if (argument.indexOf(100) > -1) {
                    dirs = true;
                }
                if (argument.indexOf(102) > -1) {
                    files = true;
                }
            }
            if (deltas == 0) {
                deltas = 7;
            }
            if (!dirs && !files) {
                dirs = true;
                files = true;
            }
            final int trackDeltas = deltas;
            final boolean trackDirs = dirs;
            final boolean trackFiles = files;
            buildDelta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    String osPath;
                    boolean isTracked;
                    IResource resource = delta.getResource();
                    boolean bl = isTracked = (delta.getKind() & trackDeltas) > 0;
                    if (isTracked) {
                        isTracked = trackDirs && resource.getType() != 1;
                        isTracked |= trackFiles && resource.getType() == 1;
                    }
                    if (isTracked && changedResources.add(osPath = resource.getLocation().toOSString())) {
                        if (fileList.length() > 0) {
                            fileList.append(BuildFilesResolver.FILE_LIST_SEPARATOR);
                        }
                        osPath = osPath.replaceAll("\"", "\\\\\"");
                        fileList.append("\"" + osPath + "\"");
                    }
                    return true;
                }
            }, deltas);
            result = fileList.toString();
        }
        return result;
    }
}

