/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.statesystem.mipmap;

import java.util.List;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.mipmap.TmfMipmapFeature;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;

public class MinMipmapFeature
extends TmfMipmapFeature {
    public MinMipmapFeature(int baseQuark, int mipmapQuark, int mipmapResolution, ITmfStateSystemBuilder ss) {
        super(baseQuark, mipmapQuark, mipmapResolution, ss);
    }

    @Override
    protected ITmfStateValue computeMipmapValue(List<ITmfStateInterval> lowerIntervals, long startTime, long endTime) {
        ITmfStateValue minValue = null;
        try {
            for (ITmfStateInterval interval : lowerIntervals) {
                ITmfStateValue value = interval.getStateValue();
                if (value.getType() == ITmfStateValue.Type.DOUBLE) {
                    if (minValue != null && !(value.unboxDouble() < minValue.unboxDouble())) continue;
                    minValue = value;
                    continue;
                }
                if (minValue != null && value.unboxLong() >= minValue.unboxLong()) continue;
                minValue = value;
            }
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
        return (ITmfStateValue)NonNullUtils.checkNotNull(minValue);
    }
}

