/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph;

import com.google.common.collect.ImmutableMap;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Map;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.AggregatedCalledFunctionStatistics;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.SymbolAspect;
import org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph.FlameGraphView;
import org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph.FlamegraphEvent;
import org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph.Messages;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class FlameGraphPresentationProvider
extends TimeGraphPresentationProvider {
    public static final int NUM_COLORS = 360;
    private static final StateItem[] STATE_TABLE;
    private static final Format FORMATTER;
    private FlameGraphView fView;
    private Integer fAverageCharWidth;

    static {
        float saturation = 0.6f;
        float brightness = 0.6f;
        STATE_TABLE = new StateItem[361];
        FlameGraphPresentationProvider.STATE_TABLE[0] = new StateItem(State.MULTIPLE.rgb, State.MULTIPLE.toString());
        int i = 0;
        while (i < 360) {
            RGB rgb = new RGB((float)i, 0.6f, 0.6f);
            FlameGraphPresentationProvider.STATE_TABLE[i + 1] = new StateItem(rgb, State.EXEC.toString());
            ++i;
        }
        FORMATTER = new SubSecondTimeWithUnitFormat();
    }

    public StateItem[] getStateTable() {
        return STATE_TABLE;
    }

    public boolean displayTimesInTooltip() {
        return false;
    }

    public String getStateTypeName() {
        return Messages.FlameGraph_Depth;
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        AggregatedCalledFunctionStatistics statistics = ((FlamegraphEvent)event).getStatistics();
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)Messages.FlameGraph_NbCalls, (Object)NumberFormat.getIntegerInstance().format(statistics.getDurationStatistics().getNbElements()));
        builder.put((Object)String.valueOf(Messages.FlameGraph_Durations), (Object)"");
        builder.put((Object)("\t" + Messages.FlameGraph_Duration), (Object)FORMATTER.format(event.getDuration()));
        builder.put((Object)("\t" + Messages.FlameGraph_AverageDuration), (Object)FORMATTER.format(statistics.getDurationStatistics().getMean()));
        builder.put((Object)("\t" + Messages.FlameGraph_MaxDuration), (Object)FORMATTER.format(statistics.getDurationStatistics().getMax()));
        builder.put((Object)("\t" + Messages.FlameGraph_MinDuration), (Object)FORMATTER.format(statistics.getDurationStatistics().getMin()));
        builder.put((Object)("\t" + Messages.FlameGraph_Deviation), (Object)FORMATTER.format(statistics.getDurationStatistics().getStdDev()));
        builder.put((Object)Messages.FlameGraph_SelfTimes, (Object)"");
        builder.put((Object)("\t" + Messages.FlameGraph_SelfTime), (Object)FORMATTER.format(((FlamegraphEvent)event).getSelfTime()));
        builder.put((Object)("\t" + Messages.FlameGraph_AverageSelfTime), (Object)FORMATTER.format(statistics.getSelfTimeStatistics().getMean()));
        builder.put((Object)("\t" + Messages.FlameGraph_MaxSelfTime), (Object)FORMATTER.format(statistics.getSelfTimeStatistics().getMax()));
        builder.put((Object)("\t" + Messages.FlameGraph_MinSelfTime), (Object)FORMATTER.format(statistics.getSelfTimeStatistics().getMin()));
        builder.put((Object)("\t" + Messages.FlameGraph_SelfTimeDeviation), (Object)FORMATTER.format(statistics.getSelfTimeStatistics().getStdDev()));
        return builder.build();
    }

    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof FlamegraphEvent) {
            FlamegraphEvent flameGraphEvent = (FlamegraphEvent)event;
            return flameGraphEvent.getValue() + 1;
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return State.MULTIPLE.ordinal();
    }

    private static String getFunctionSymbol(FlamegraphEvent event) {
        String funcSymbol = "";
        if (event.getSymbol() instanceof Long || event.getSymbol() instanceof Integer) {
            ICalledFunction segment = (ICalledFunction)event.getStatistics().getDurationStatistics().getMinObject();
            if (segment == null) {
                long longAddress = (Long)event.getSymbol();
                return "0x" + Long.toHexString(longAddress);
            }
            Object symbol = SymbolAspect.SYMBOL_ASPECT.resolve((ISegment)segment);
            if (symbol != null) {
                return symbol.toString();
            }
        } else {
            return event.getSymbol().toString();
        }
        return funcSymbol;
    }

    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
        if (this.fAverageCharWidth == null) {
            this.fAverageCharWidth = gc.getFontMetrics().getAverageCharWidth();
        }
        if (bounds.width <= this.fAverageCharWidth) {
            return;
        }
        if (!(event instanceof FlamegraphEvent)) {
            return;
        }
        String funcSymbol = "";
        ITmfTrace activeTrace = TmfTraceManager.getInstance().getActiveTrace();
        if (activeTrace != null) {
            FlamegraphEvent fgEvent = (FlamegraphEvent)event;
            funcSymbol = FlameGraphPresentationProvider.getFunctionSymbol(fgEvent);
        }
        gc.setForeground(gc.getDevice().getSystemColor(1));
        Utils.drawText((GC)gc, (String)funcSymbol, (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, (boolean)true, (boolean)true);
    }

    public FlameGraphView getView() {
        return this.fView;
    }

    public void setView(FlameGraphView view) {
        this.fView = view;
    }

    private static enum State {
        MULTIPLE(new RGB(100, 100, 100)),
        EXEC(new RGB(0, 200, 0));

        private final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

