/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.AsyncCallbackCollector;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.model.interfaces.IContainerModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.contexts.IAsyncRefreshableCtx;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.core.util.persistence.PeerDataHelper;
import org.eclipse.tcf.te.tcf.locator.interfaces.ILocatorModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.model.ModelLocationUtil;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.ui.dialogs.AbstractTreeSelectionDialog;
import org.eclipse.tcf.te.tcf.ui.editor.sections.TcpTransportSection;
import org.eclipse.tcf.te.tcf.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.navigator.ContentProvider;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.async.UICallbackInvocationDelegate;
import org.eclipse.tcf.te.ui.dialogs.AbstractSectionDialog;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.tcf.te.ui.views.extensions.CategoriesExtensionPointManager;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.tcf.te.ui.views.navigator.DelegatingLabelProvider;
import org.eclipse.ui.forms.IManagedForm;

public class LocatorNodeSelectionDialog
extends AbstractTreeSelectionDialog
implements ILocatorModelListener {
    Button addButton;
    Button deleteButton;
    Button refreshButton;
    final boolean isProxyAllowed;

    public LocatorNodeSelectionDialog(Shell shell, boolean isProxyAllowed) {
        super(shell, IContextHelpIds.LOCATOR_NODE_SELECTION_DIALOG);
        this.isProxyAllowed = isProxyAllowed;
        ModelManager.getLocatorModel().addListener((ILocatorModelListener)this);
    }

    @Override
    protected void createButtonAreaContent(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        GridData layoutData = new GridData(0, 4, false, true);
        comp.setLayoutData((Object)layoutData);
        this.addButton = new Button(comp, 8);
        layoutData = new GridData(4, 4, false, false);
        this.addButton.setLayoutData((Object)layoutData);
        this.addButton.setText(" " + Messages.LocatorNodeSelectionDialog_button_add + " ");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocatorNodeSelectionDialog.this.onButtonAddSelected();
            }
        });
        this.deleteButton = new Button(comp, 8);
        layoutData = new GridData(4, 4, false, false);
        this.deleteButton.setLayoutData((Object)layoutData);
        this.deleteButton.setText(" " + Messages.LocatorNodeSelectionDialog_button_delete + " ");
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocatorNodeSelectionDialog.this.onButtonDeleteSelected();
            }
        });
        Composite spacer = new Composite(comp, 0);
        layoutData = new GridData(4, 4, false, true);
        spacer.setLayoutData((Object)layoutData);
        this.refreshButton = new Button(comp, 8);
        layoutData = new GridData(4, 4, false, false);
        this.refreshButton.setLayoutData((Object)layoutData);
        this.refreshButton.setText(" " + Messages.LocatorNodeSelectionDialog_button_refresh + " ");
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocatorNodeSelectionDialog.this.onButtonRefreshSelected();
            }
        });
    }

    protected void onButtonAddSelected() {
        ISelection sel = this.getViewer().getSelection();
        if (sel instanceof IStructuredSelection) {
            String encProxies;
            Object element = ((IStructuredSelection)sel).getFirstElement();
            if (element instanceof ICategory) {
                encProxies = null;
            } else if (element instanceof ILocatorNode) {
                ILocatorNode parent = (ILocatorNode)element;
                String parentProxies = (String)parent.getPeer().getAttributes().get("Proxies");
                IPeer[] proxies = PeerDataHelper.decodePeerList((String)parentProxies);
                ArrayList<IPeer> proxiesList = new ArrayList<IPeer>(Arrays.asList(proxies));
                proxiesList.add(parent.getPeer());
                proxies = proxiesList.toArray(new IPeer[proxiesList.size()]);
                encProxies = PeerDataHelper.encodePeerList((IPeer[])proxies);
            } else {
                return;
            }
            AbstractSectionDialog dialog = new AbstractSectionDialog(this.getShell(), Messages.LocatorNodeSelectionDialog_add_dialogTitle, Messages.LocatorNodeSelectionDialog_add_title, Messages.LocatorNodeSelectionDialog_add_message, false, null){

                protected AbstractSection[] createSections(IManagedForm form, Composite parent) {
                    return new AbstractSection[]{new TcpTransportSection(form, parent, false)};
                }
            };
            PropertiesContainer data = new PropertiesContainer();
            data.setProperty("Proxies", encProxies);
            data.setProperty("TransportName", (Object)"TCP");
            data.setProperty("Port", (Object)"1534");
            dialog.setupData((IPropertiesContainer)data);
            if (dialog.open() == 0) {
                dialog.extractData((IPropertiesContainer)data);
                String proxy = data.getStringProperty("Proxies");
                String host = data.getStringProperty("Host");
                String port = data.getStringProperty("Port");
                String transport = data.getStringProperty("TransportName");
                String id = String.valueOf(transport) + ":" + host + ":" + port;
                HashMap<String, String> attrs = new HashMap<String, String>();
                attrs.put("ID", id);
                attrs.put("Host", host);
                attrs.put("Port", port);
                attrs.put("TransportName", transport);
                attrs.put("Proxies", proxy);
                TransientPeer peer = new TransientPeer(attrs);
                Protocol.invokeLater((Runnable)new Runnable((IPeer)peer){
                    private final /* synthetic */ IPeer val$peer;
                    {
                        this.val$peer = iPeer;
                    }

                    @Override
                    public void run() {
                        final ILocatorModelLookupService lkup = (ILocatorModelLookupService)ModelManager.getLocatorModel().getService(ILocatorModelLookupService.class);
                        ILocatorModelRefreshService refresh = (ILocatorModelRefreshService)ModelManager.getLocatorModel().getService(ILocatorModelRefreshService.class);
                        ILocatorNode node = lkup.lkupLocatorNode(this.val$peer);
                        if (node == null || !node.isStatic()) {
                            try {
                                IURIPersistenceService persistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                                String id = this.val$peer.getID();
                                String name = id.replaceAll("\\W", "_").trim();
                                IPath basePath = ModelLocationUtil.getStaticLocatorsRootLocation();
                                IPath path = basePath.append(name).addFileExtension("locator");
                                int i = 0;
                                while (path.toFile().exists()) {
                                    path = basePath.append(String.valueOf(name) + "_" + i).addFileExtension("locator");
                                }
                                persistenceService.write((Object)this.val$peer, path.toFile().toURI());
                            }
                            catch (Exception exception) {}
                            refresh.refresh((ICallback)new Callback(){

                                protected void internalDone(Object caller, IStatus status) {
                                    final ILocatorNode node = lkup.lkupLocatorNode(val$peer);
                                    LocatorNodeSelectionDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (node != null) {
                                                LocatorNodeSelectionDialog.this.setSelection((ISelection)new StructuredSelection((Object)node));
                                                LocatorNodeSelectionDialog.this.updateSelection(LocatorNodeSelectionDialog.this.getSelection());
                                            }
                                        }
                                    });
                                }
                            });
                        } else {
                            refresh.refresh(node, (ICallback)new Callback(){

                                protected void internalDone(Object caller, IStatus status) {
                                    final ILocatorNode node = lkup.lkupLocatorNode(val$peer);
                                    LocatorNodeSelectionDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (node != null) {
                                                LocatorNodeSelectionDialog.this.setSelection((ISelection)new StructuredSelection((Object)node));
                                                LocatorNodeSelectionDialog.this.updateSelection(LocatorNodeSelectionDialog.this.getSelection());
                                            }
                                        }
                                    });
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    protected void onButtonDeleteSelected() {
        final ISelection sel = this.getViewer().getSelection();
        if (sel instanceof IStructuredSelection) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Object element = ((IStructuredSelection)sel).getFirstElement();
                    if (element instanceof ILocatorNode) {
                        LocatorNodeSelectionDialog.this.doDelete((ILocatorNode)element);
                        ILocatorModelRefreshService refresh = (ILocatorModelRefreshService)ModelManager.getLocatorModel().getService(ILocatorModelRefreshService.class);
                        refresh.refresh(null);
                    }
                }
            });
        }
    }

    protected void doDelete(ILocatorNode locatorNode) {
        for (ILocatorNode child : locatorNode.getChildren(ILocatorNode.class)) {
            this.doDelete(child);
        }
        if (locatorNode.isStatic()) {
            IURIPersistenceService persistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
            try {
                persistenceService.delete(locatorNode.isDiscovered() ? locatorNode.getProperty("staticInstance") : locatorNode.getPeer(), null);
            }
            catch (Exception exception) {}
            ILocatorModelUpdateService update = (ILocatorModelUpdateService)ModelManager.getLocatorModel().getService(ILocatorModelUpdateService.class);
            update.remove(locatorNode.getPeer());
        }
    }

    protected void onButtonRefreshSelected() {
        final ISelection sel = this.getViewer().getSelection();
        if (sel instanceof IStructuredSelection) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ILocatorModelRefreshService service = (ILocatorModelRefreshService)ModelManager.getLocatorModel().getService(ILocatorModelRefreshService.class);
                    Object element = ((IStructuredSelection)sel).getFirstElement();
                    if (element instanceof ICategory) {
                        service.refresh(null);
                    }
                    if (element instanceof ILocatorNode) {
                        service.refresh((ILocatorNode)element, null);
                    }
                }
            });
        }
    }

    protected void dispose() {
        super.dispose();
        ModelManager.getLocatorModel().removeListener((ILocatorModelListener)this);
    }

    @Override
    protected Object getInput() {
        return ModelManager.getLocatorModel();
    }

    @Override
    protected IBaseLabelProvider getLabelProvider() {
        TargetStyledLabelProvider labelProvider = new TargetStyledLabelProvider();
        return new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider, (ILabelDecorator)labelProvider, null);
    }

    @Override
    protected IContentProvider getContentProvider() {
        return new ContentProvider(){

            @Override
            public Object[] getChildren(Object parentElement) {
                if (LocatorNodeSelectionDialog.this.isProxyAllowed || parentElement instanceof ILocatorModel || parentElement instanceof ICategory) {
                    return super.getChildren(parentElement);
                }
                return new Object[0];
            }

            @Override
            public boolean hasChildren(Object element) {
                if (LocatorNodeSelectionDialog.this.isProxyAllowed || element instanceof ILocatorModel || element instanceof ICategory) {
                    return super.hasChildren(element);
                }
                return false;
            }
        };
    }

    protected Object getViewerSelection() {
        ISelection sel = this.getViewer().getSelection();
        if (sel instanceof IStructuredSelection) {
            return ((IStructuredSelection)sel).getFirstElement();
        }
        return null;
    }

    @Override
    protected boolean isValidSelection() {
        Object element = this.getViewerSelection();
        return element instanceof ICategory || element instanceof ILocatorNode;
    }

    @Override
    protected String getDialogTitle() {
        return Messages.LocatorNodeSelectionDialog_dialogTitle;
    }

    @Override
    protected String getTitle() {
        return Messages.LocatorNodeSelectionDialog_title;
    }

    @Override
    protected String getDefaultMessage() {
        return Messages.LocatorNodeSelectionDialog_message;
    }

    public void modelChanged(ILocatorModel model, ILocatorNode locatorNode, boolean added) {
        this.refresh();
    }

    public void modelDisposed(ILocatorModel model) {
    }

    @Override
    protected void updateEnablement(TreeViewer viewer) {
        boolean valid = this.isValidSelection();
        if (this.addButton != null && !this.addButton.isDisposed()) {
            if (this.isProxyAllowed) {
                this.addButton.setEnabled(valid);
            } else {
                this.addButton.setEnabled(this.getViewerSelection() instanceof ICategory);
            }
        }
        if (this.refreshButton != null && !this.refreshButton.isDisposed()) {
            this.refreshButton.setEnabled(valid);
        }
        if (this.deleteButton != null && !this.deleteButton.isDisposed()) {
            Object element;
            valid = false;
            ISelection sel = this.getViewer().getSelection();
            if (sel instanceof IStructuredSelection && (element = ((IStructuredSelection)sel).getFirstElement()) instanceof ILocatorNode) {
                valid = ((ILocatorNode)element).isStatic();
            }
            this.deleteButton.setEnabled(valid);
        }
        super.updateEnablement(viewer);
    }

    @Override
    protected void updateSelection(ISelection selection) {
        ICategory category = CategoriesExtensionPointManager.getInstance().getCategory("org.eclipse.tcf.te.ui.views.category.neighborhood", false);
        if (selection instanceof IStructuredSelection) {
            final Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof ILocatorNode) {
                final ArrayList<Object> treePath = new ArrayList<Object>();
                treePath.add(category);
                treePath.add(element);
                Protocol.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IContainerModelNode container = ((ILocatorNode)element).getParent();
                        while (container != null) {
                            treePath.add(1, container);
                            container = container.getParent();
                        }
                    }
                });
                final TreePath path = new TreePath(treePath.toArray());
                AsyncCallbackCollector collector = new AsyncCallbackCollector((ICallback)new Callback(){

                    protected void internalDone(Object caller, IStatus status) {
                        if (LocatorNodeSelectionDialog.this.viewer != null && !LocatorNodeSelectionDialog.this.viewer.getTree().isDisposed()) {
                            LocatorNodeSelectionDialog.this.viewer.refresh();
                            LocatorNodeSelectionDialog.this.viewer.setSelection((ISelection)new TreeSelection(path), true);
                        }
                    }
                }, (AsyncCallbackCollector.ICallbackInvocationDelegate)new UICallbackInvocationDelegate());
                for (Object e : treePath) {
                    ILocatorNode locatorNode;
                    IAsyncRefreshableCtx refreshCtx;
                    if (!(e instanceof ILocatorNode) || (refreshCtx = (IAsyncRefreshableCtx)(locatorNode = (ILocatorNode)e).getAdapter(IAsyncRefreshableCtx.class)).getQueryState(IAsyncRefreshableCtx.QueryType.CONTEXT) == IAsyncRefreshableCtx.QueryState.DONE && refreshCtx.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST) == IAsyncRefreshableCtx.QueryState.DONE) continue;
                    AsyncCallbackCollector.SimpleCollectorCallback cb = locatorNode.isStatic() ? null : new AsyncCallbackCollector.SimpleCollectorCallback(collector);
                    Protocol.invokeLater((Runnable)new Runnable((ICallback)cb){
                        private final /* synthetic */ ICallback val$cb;
                        {
                            this.val$cb = iCallback;
                        }

                        @Override
                        public void run() {
                            ((ILocatorModelRefreshService)ModelManager.getLocatorModel().getService(ILocatorModelRefreshService.class)).refresh(locatorNode, this.val$cb);
                        }
                    });
                }
                collector.initDone();
            }
        } else {
            this.viewer.expandToLevel(2);
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)category));
        }
    }

    static class TargetStyledLabelProvider
    extends DelegatingLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        TargetStyledLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            return new StyledString(this.getText(element));
        }
    }
}

