/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.diagnostic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.validation.ICompositeValidator;
import org.eclipse.sphinx.emf.validation.diagnostic.filters.ExtensionPointFilter;
import org.eclipse.sphinx.emf.validation.diagnostic.filters.util.ConstraintFilterValue;
import org.eclipse.sphinx.emf.validation.evalidator.adapter.EValidatorAdapter;

public class ExtendedDiagnostician
extends Diagnostician {
    private Set<IConstraintFilter> filters = null;
    private EObject rootObject = null;
    IProgressMonitor monitor = null;
    private int depth;
    private boolean hasBeenCanceled = false;
    private static final int VALIDATION_DEFAULT_DEPTH = 2;

    public ExtendedDiagnostician() {
        this.resetDepth();
    }

    public Diagnostic validate(EObject eObject, Set<IConstraintFilter> filters, int depth) {
        this.setDepth(depth);
        this.rootObject = eObject;
        this.filters = filters;
        this.hasBeenCanceled = false;
        HashMap<Class, ExtendedDiagnostician> context = new HashMap<Class, ExtendedDiagnostician>();
        context.put(EValidator.SubstitutionLabelProvider.class, this);
        context.put(EValidator.class, this);
        String resourceTxt = "";
        IFile iresource = EcorePlatformUtil.getFile((EObject)eObject);
        if (iresource != null) {
            resourceTxt = "( " + iresource.getName() + ")";
        }
        BasicDiagnostic diagnostics = new BasicDiagnostic("org.eclipse.emf.ecore", 0, EcorePlugin.INSTANCE.getString("_UI_DiagnosticRoot_diagnostic", new Object[]{String.valueOf(this.getObjectLabel(eObject)) + resourceTxt}), new Object[]{eObject});
        this.validate(eObject, (DiagnosticChain)diagnostics, context);
        this.resetDepth();
        this.unsetFilter();
        return diagnostics;
    }

    public Diagnostic validate(EObject eObject, IConstraintFilter filter, int depth) {
        HashSet<IConstraintFilter> l = null;
        if (filter != null) {
            l = new HashSet<IConstraintFilter>();
            l.add(filter);
        } else {
            l = Collections.EMPTY_SET;
        }
        return this.validate(eObject, l, depth);
    }

    public Diagnostic validate(EObject eObject, IConstraintFilter filter) {
        return this.validate(eObject, filter, 2);
    }

    public Diagnostic validate(EObject eObject, Set<IConstraintFilter> filters) {
        return this.validate(eObject, filters, 2);
    }

    public Diagnostic validate(EObject eObject, ConstraintFilterValue cfv, int depth) {
        HashSet<IConstraintFilter> l = new HashSet<IConstraintFilter>();
        l.add(new ExtensionPointFilter(cfv));
        return this.validate(eObject, l, depth);
    }

    public Diagnostic validate(EObject eObject, ConstraintFilterValue cfv) {
        return this.validate(eObject, cfv, 2);
    }

    public Diagnostic validate(EObject eObject, int depth) {
        return this.validate(eObject, Collections.EMPTY_SET, depth);
    }

    public Diagnostic validate(EObject eObject) {
        return this.validate(eObject, 2);
    }

    protected EObjectValidator findEValidator(EClass eClass) {
        Object eValidatorObject = this.eValidatorRegistry.get((Object)eClass.getEPackage());
        if (eValidatorObject instanceof EValidatorAdapter) {
            return (EValidatorAdapter)((Object)eValidatorObject);
        }
        if (eValidatorObject instanceof ICompositeValidator) {
            for (EValidator eValidator : ((ICompositeValidator)eValidatorObject).getValidators()) {
                if (!(eValidator instanceof EValidatorAdapter)) continue;
                return (EValidatorAdapter)eValidator;
            }
        }
        for (EClass eSuperType : eClass.getESuperTypes()) {
            eValidatorObject = this.findEValidator(eSuperType);
            if (!(eValidatorObject instanceof EValidatorAdapter)) continue;
            return (EValidatorAdapter)((Object)eValidatorObject);
        }
        eValidatorObject = this.eValidatorRegistry.get(null);
        return eValidatorObject instanceof EObjectValidator ? (EObjectValidator)eValidatorObject : null;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EObjectValidator eValidator = this.findEValidator(eClass);
        if (eValidator == null) {
            return true;
        }
        boolean result = false;
        boolean goNext = true;
        if (this.depth == 1) {
            goNext = eObject == this.rootObject || eObject.eContainer() != null && eObject.eContainer() == this.rootObject;
        }
        if (goNext) {
            boolean bl = result = eValidator instanceof EValidatorAdapter ? ((EValidatorAdapter)eValidator).validate(eClass, eObject, diagnostics, context, this.filters) : eValidator.validate(eClass, eObject, diagnostics, context);
            if (this.isAnyProgressMonitor()) {
                this.monitor.worked(1);
                if (this.monitor.isCanceled()) {
                    this.hasBeenCanceled = true;
                    return false;
                }
            }
        } else {
            return result;
        }
        if (this.depth == 0) {
            goNext = false;
        }
        if (this.depth == 1 && eObject != this.rootObject) {
            goNext = false;
        }
        if (goNext && (result || diagnostics != null)) {
            result &= this.doValidateContents(eObject, diagnostics, context);
        }
        return result;
    }

    protected boolean doValidateContents(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList eContents = eObject.eContents();
        if (!eContents.isEmpty()) {
            Iterator i = eContents.iterator();
            EObject child = (EObject)i.next();
            boolean result = this.validate(child, diagnostics, context);
            while (i.hasNext() && (result || diagnostics != null)) {
                child = (EObject)i.next();
                result &= this.validate(child, diagnostics, context);
            }
            return result;
        }
        return true;
    }

    public void setFilter(IConstraintFilter icf) {
        if (icf == null) {
            return;
        }
        this.filters = new HashSet<IConstraintFilter>();
        this.filters.add(icf);
    }

    public void setFilter(Set<IConstraintFilter> icfs) {
        this.filters = icfs;
    }

    protected void unsetFilter() {
        this.filters = null;
    }

    public void setDepth(int value) {
        switch (value) {
            case 0: {
                this.depth = 0;
                break;
            }
            case 1: {
                this.depth = 1;
                break;
            }
            case 2: {
                this.depth = 2;
                break;
            }
            default: {
                this.depth = 2;
            }
        }
    }

    private void resetDepth() {
        this.depth = 2;
        this.rootObject = null;
    }

    public String getObjectLabel(final EObject eObject) {
        String result = "";
        final TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)eObject);
        if (editingDomain != null) {
            RunnableWithResult.Impl<String> runnable = new RunnableWithResult.Impl<String>(){

                public void run() {
                    this.setResult(ExtendedDiagnostician.this.doGetObjectLabel(editingDomain, eObject));
                }
            };
            try {
                result = (String)TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, (RunnableWithResult)runnable);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            result = this.doGetObjectLabel(editingDomain, eObject);
        }
        return result;
    }

    protected String doGetObjectLabel(TransactionalEditingDomain editingDomain, EObject eObject) {
        if (editingDomain != null) {
            AdapterFactory adapterFactory = ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
            AdapterFactoryItemDelegator delegator = new AdapterFactoryItemDelegator(adapterFactory);
            return delegator.getText((Object)eObject);
        }
        return super.getObjectLabel(eObject);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public boolean isAnyProgressMonitor() {
        return this.monitor != null;
    }

    public boolean isCanceled() {
        return this.hasBeenCanceled;
    }
}

