/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.movida.registry.monitoring;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.componentization.ISiriusComponent;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry;
import org.eclipse.sirius.business.internal.movida.registry.monitoring.AbstractViewpointResourceMonitor;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class LegacyPluginMonitor
extends AbstractViewpointResourceMonitor {
    private final ViewpointRegistry registry;
    private final Set<URI> knownURIs = Sets.newHashSet();

    public LegacyPluginMonitor(ViewpointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void start() {
        this.running = true;
        EclipseUtil.getExtensionPlugins(ISiriusComponent.CLASS_TO_EXTEND, (String)"org.eclipse.sirius.componentization", (String)"class");
    }

    @Override
    public void stop() {
        this.running = false;
    }

    public Set<Viewpoint> registerFromPlugin(String modelerModelResourcePath) {
        try {
            URI uri = URI.createPlatformPluginURI((String)modelerModelResourcePath, (boolean)true);
            return this.registerFromPlugin(uri);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.emptySet();
        }
    }

    private Set<Viewpoint> registerFromPlugin(final URI uri) {
        if (this.knownURIs.contains(uri)) {
            this.notifyResourcesEvents(Collections.emptySet(), Collections.emptySet(), Collections.singleton(uri));
        } else {
            this.notifyResourcesEvents(Collections.emptySet(), Collections.singleton(uri), Collections.emptySet());
        }
        return ImmutableSet.copyOf((Iterable)Iterables.filter(this.registry.getViewpoints(), (Predicate)new Predicate<Viewpoint>(){

            public boolean apply(Viewpoint input) {
                Resource r = input.eResource();
                return r != null && r.getURI().equals(uri);
            }
        }));
    }

    public void disposeFromPlugin(Viewpoint viewpoint) {
        Option<URI> uri;
        if (viewpoint != null && (uri = new ViewpointQuery(viewpoint).getViewpointURI()).some()) {
            this.notifyResourcesEvents(Collections.singleton((URI)uri.get()), Collections.emptySet(), Collections.emptySet());
            this.knownURIs.remove(uri.get());
        }
    }
}

