/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.contribution;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.description.contribution.AddFeatureContribution;
import org.eclipse.sirius.description.contribution.ComputedEObjectReference;
import org.eclipse.sirius.description.contribution.Contribution;
import org.eclipse.sirius.description.contribution.ContributionFactory;
import org.eclipse.sirius.description.contribution.DirectEObjectReference;
import org.eclipse.sirius.description.contribution.FeatureContribution;
import org.eclipse.sirius.description.contribution.RemoveFeatureContribution;
import org.eclipse.sirius.description.contribution.SetFeatureContribution;
import org.eclipse.sirius.ext.emf.EStructuralFeatureQuery;

public class ContributionBuilder {
    private static ContributionFactory factory = ContributionFactory.eINSTANCE;
    private EClass sourceType;
    private EClass targetType;
    private Contribution contribution = factory.createContribution();

    public Contribution build() {
        return this.contribution;
    }

    public ContributionBuilder from(EObject source) {
        this.sourceType = source.eClass();
        DirectEObjectReference ref = factory.createDirectEObjectReference();
        ref.setValue(source);
        this.contribution.setSource(ref);
        return this;
    }

    public ContributionBuilder from(String expression, EClass srcType) {
        this.sourceType = srcType;
        ComputedEObjectReference ref = factory.createComputedEObjectReference();
        ref.setValueExpression(expression);
        this.contribution.setSource(ref);
        return this;
    }

    public ContributionBuilder to(EObject target) {
        this.targetType = target.eClass();
        DirectEObjectReference ref = factory.createDirectEObjectReference();
        ref.setValue(target);
        this.contribution.setTarget(ref);
        return this;
    }

    public ContributionBuilder to(String expression, EClass tgtType) {
        this.targetType = tgtType;
        ComputedEObjectReference ref = factory.createComputedEObjectReference();
        ref.setValueExpression(expression);
        this.contribution.setTarget(ref);
        return this;
    }

    public ContributionBuilder keep(EStructuralFeature targetFeature) {
        this.removeFeatureContributionsTo(targetFeature);
        return this;
    }

    public ContributionBuilder keep(String targetFeature) {
        return this.keep(this.targetType.getEStructuralFeature(targetFeature));
    }

    public ContributionBuilder set(EStructuralFeature targetFeature, EStructuralFeature sourceFeature) {
        SetFeatureContribution fc = factory.createSetFeatureContribution();
        this.configureFeatureContribution(fc, targetFeature, sourceFeature);
        return this;
    }

    public ContributionBuilder set(EStructuralFeature feature) {
        return this.set(feature, feature);
    }

    public ContributionBuilder set(String targetFeature, String sourceFeature) {
        return this.set(this.targetType.getEStructuralFeature(targetFeature), this.sourceType.getEStructuralFeature(sourceFeature));
    }

    public ContributionBuilder set(String feature) {
        return this.set(feature, feature);
    }

    public ContributionBuilder setAllAttributes() {
        for (EAttribute attr : this.targetType.getEAllAttributes()) {
            if (!attr.isChangeable() || attr.isDerived()) continue;
            this.set((EStructuralFeature)attr);
        }
        return this;
    }

    public ContributionBuilder addAllAttributes() {
        for (EAttribute attr : this.targetType.getEAllAttributes()) {
            if (!attr.isChangeable() || attr.isDerived() || !attr.isMany()) continue;
            this.add((EStructuralFeature)attr);
        }
        return this;
    }

    public ContributionBuilder add(EStructuralFeature targetFeature, EStructuralFeature sourceFeature) {
        AddFeatureContribution fc = factory.createAddFeatureContribution();
        this.configureFeatureContribution(fc, targetFeature, sourceFeature);
        return this;
    }

    public ContributionBuilder add(EStructuralFeature feature) {
        return this.add(feature, feature);
    }

    public ContributionBuilder add(String targetFeature, String sourceFeature) {
        return this.add(this.targetType.getEStructuralFeature(targetFeature), this.sourceType.getEStructuralFeature(sourceFeature));
    }

    public ContributionBuilder add(String feature) {
        return this.add(feature, feature);
    }

    public ContributionBuilder remove(EStructuralFeature targetFeature, EStructuralFeature sourceFeature) {
        RemoveFeatureContribution fc = factory.createRemoveFeatureContribution();
        this.configureFeatureContribution(fc, targetFeature, sourceFeature);
        return this;
    }

    public ContributionBuilder remove(EStructuralFeature feature) {
        return this.remove(feature, feature);
    }

    public ContributionBuilder remove(String targetFeature, String sourceFeature) {
        return this.remove(this.targetType.getEStructuralFeature(targetFeature), this.sourceType.getEStructuralFeature(sourceFeature));
    }

    public ContributionBuilder remove(String feature) {
        return this.remove(feature, feature);
    }

    private void configureFeatureContribution(FeatureContribution fc, EStructuralFeature targetFeature, EStructuralFeature sourceFeature) {
        Preconditions.checkArgument((boolean)new EStructuralFeatureQuery(sourceFeature).isAssignableFrom(targetFeature));
        fc.setSourceFeature(sourceFeature);
        fc.setTargetFeature(targetFeature);
        this.addFeatureContribution(fc);
    }

    private void addFeatureContribution(FeatureContribution fc) {
        this.removeFeatureContributionsTo(fc.getTargetFeature());
        this.contribution.getFeatureMask().add((Object)fc);
    }

    private void removeFeatureContributionsTo(EStructuralFeature targetFeature) {
        Iterator iter = this.contribution.getFeatureMask().iterator();
        while (iter.hasNext()) {
            FeatureContribution existingFc = (FeatureContribution)iter.next();
            if (!existingFc.getTargetFeature().equals(targetFeature)) continue;
            iter.remove();
        }
    }
}

