/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.commands;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.ui.business.internal.operation.ShiftDirectBorderedNodesOperation;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.figure.locator.DBorderItemLocator;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.distribute.DistributeAction;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;

public class DistributeCommand
extends AbstractTransactionalCommand {
    CompositeTransactionalCommand wrappedCommand;
    List<IGraphicalEditPart> editPartsToDistribute;
    private int distributeType;

    public DistributeCommand(TransactionalEditingDomain domain, List<IGraphicalEditPart> editPartsToDistribute, int distributeType) {
        super(domain, DistributeAction.getLabel(distributeType, true), null);
        this.editPartsToDistribute = editPartsToDistribute;
        this.distributeType = distributeType;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) {
        CommandResult result = CommandResult.newOKCommandResult();
        if (this.wrappedCommand == null) {
            this.wrappedCommand = new CompositeTransactionalCommand(this.getEditingDomain(), this.getLabel());
            HashMap partToBounds = Maps.newHashMap();
            for (IGraphicalEditPart part : this.editPartsToDistribute) {
                Rectangle bounds = part.getFigure().getBounds().getCopy();
                partToBounds.put(part, bounds);
            }
            if (this.distributeType == 0) {
                this.distributeHorizontallyWithUniformGaps(partToBounds);
            } else if (this.distributeType == 1) {
                this.distributeCentersHorizontally(partToBounds);
            } else if (this.distributeType == 2) {
                this.distributeVerticallyWithUniformGaps(partToBounds);
            } else if (this.distributeType == 3) {
                this.distributeCentersVertically(partToBounds);
            }
        }
        if (this.wrappedCommand.size() > 0) {
            if (this.wrappedCommand.canExecute()) {
                try {
                    this.wrappedCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    result = CommandResult.newErrorCommandResult((Throwable)e);
                }
            } else {
                result = CommandResult.newWarningCommandResult((String)Messages.DistributeCommand_errorMsg, null);
            }
        }
        return result;
    }

    private void distributeHorizontallyWithUniformGaps(final HashMap<IGraphicalEditPart, Rectangle> partsToBounds) {
        GetNewBoundsFunction setXFunction = new GetNewBoundsFunction(this){

            public Rectangle apply(IGraphicalEditPart input) {
                return ((Rectangle)partsToBounds.get(input)).getCopy().setX(this.previousPartBounds.getRight().x + this.gap);
            }
        };
        this.distributeWithUniformGaps(partsToBounds.keySet(), new GetLeftFunction(partsToBounds), new GetTopFunction(partsToBounds), new GetRightFunction(partsToBounds), new GetBottomFunction(partsToBounds), new GetWidthFunction(partsToBounds), new PartByCenter(partsToBounds), setXFunction, (Function<IGraphicalEditPart, Rectangle>)Functions.forMap(partsToBounds));
    }

    private void distributeVerticallyWithUniformGaps(final HashMap<IGraphicalEditPart, Rectangle> partsToBounds) {
        GetNewBoundsFunction setYFunction = new GetNewBoundsFunction(this){

            public Rectangle apply(IGraphicalEditPart input) {
                return ((Rectangle)partsToBounds.get(input)).getCopy().setY(this.previousPartBounds.getBottom().y + this.gap);
            }
        };
        this.distributeWithUniformGaps(partsToBounds.keySet(), new GetTopFunction(partsToBounds), new GetLeftFunction(partsToBounds), new GetBottomFunction(partsToBounds), new GetRightFunction(partsToBounds), new GetHeightFunction(partsToBounds), new PartByMiddle(partsToBounds), setYFunction, (Function<IGraphicalEditPart, Rectangle>)Functions.forMap(partsToBounds));
    }

    private void distributeWithUniformGaps(Set<IGraphicalEditPart> partsToDistribute, Function<IGraphicalEditPart, Integer> getFirstPartMainAxisFunction, Function<IGraphicalEditPart, Integer> getFirstPartSecondAxisFunction, Function<IGraphicalEditPart, Integer> getLastPartMainAxisFunction, Function<IGraphicalEditPart, Integer> getLastPartSecondAxisFunction, Function<IGraphicalEditPart, Integer> getSizeFunction, Comparator<IGraphicalEditPart> comparator, GetNewBoundsFunction setValueFunction, Function<IGraphicalEditPart, Rectangle> getBoundsFunction) {
        this.distribute(partsToDistribute, getFirstPartMainAxisFunction, getFirstPartSecondAxisFunction, getLastPartMainAxisFunction, getLastPartSecondAxisFunction, comparator, setValueFunction, getBoundsFunction, new GetGapFunction(this, partsToDistribute, getFirstPartMainAxisFunction, getLastPartMainAxisFunction, getSizeFunction){

            @Override
            public int apply(IGraphicalEditPart firstPart, IGraphicalEditPart lastPart) {
                int availableSpaceBetweenFirstAndLast;
                int availableSpace = availableSpaceBetweenFirstAndLast = (Integer)this.getFirstPartMainAxisFunction.apply((Object)lastPart) - (Integer)this.getLastPartMainAxisFunction.apply((Object)firstPart);
                for (IGraphicalEditPart part : this.partsToDistribute) {
                    if (part.equals(firstPart) || part.equals(lastPart)) continue;
                    availableSpace -= ((Integer)this.getSizeFunction.apply((Object)part)).intValue();
                }
                return Math.round((float)availableSpace / (float)(this.partsToDistribute.size() - 1));
            }
        });
    }

    private void distributeCentersHorizontally(final HashMap<IGraphicalEditPart, Rectangle> partsToBounds) {
        GetNewBoundsFunction setCenterFunction = new GetNewBoundsFunction(this){

            public Rectangle apply(IGraphicalEditPart input) {
                Rectangle r = ((Rectangle)partsToBounds.get(input)).getCopy();
                return r.setX(this.previousPartBounds.getCenter().x + this.gap - r.width / 2);
            }
        };
        this.distributeCenters(partsToBounds.keySet(), new GetCenterFunction(partsToBounds), new GetTopFunction(partsToBounds), new GetBottomFunction(partsToBounds), new GetWidthFunction(partsToBounds), new PartByCenter(partsToBounds), setCenterFunction, (Function<IGraphicalEditPart, Rectangle>)Functions.forMap(partsToBounds));
    }

    private void distributeCentersVertically(final HashMap<IGraphicalEditPart, Rectangle> partsToBounds) {
        GetNewBoundsFunction setMiddleFunction = new GetNewBoundsFunction(this){

            public Rectangle apply(IGraphicalEditPart input) {
                Rectangle r = ((Rectangle)partsToBounds.get(input)).getCopy();
                return r.setY(this.previousPartBounds.getCenter().y + this.gap - r.height / 2);
            }
        };
        this.distributeCenters(partsToBounds.keySet(), new GetMiddleFunction(partsToBounds), new GetLeftFunction(partsToBounds), new GetRightFunction(partsToBounds), new GetHeightFunction(partsToBounds), new PartByMiddle(partsToBounds), setMiddleFunction, (Function<IGraphicalEditPart, Rectangle>)Functions.forMap(partsToBounds));
    }

    private void distributeCenters(Set<IGraphicalEditPart> partsToDistribute, Function<IGraphicalEditPart, Integer> getMainAxisFunction, Function<IGraphicalEditPart, Integer> getFirstPartSecondAxisFunction, Function<IGraphicalEditPart, Integer> getLastPartSecondAxisFunction, Function<IGraphicalEditPart, Integer> getSizeFunction, Comparator<IGraphicalEditPart> comparator, GetNewBoundsFunction setValueFunction, Function<IGraphicalEditPart, Rectangle> getBoundsFunction) {
        this.distribute(partsToDistribute, getMainAxisFunction, getFirstPartSecondAxisFunction, getMainAxisFunction, getLastPartSecondAxisFunction, comparator, setValueFunction, getBoundsFunction, new GetGapFunction(this, partsToDistribute, getMainAxisFunction, getMainAxisFunction, getSizeFunction){

            @Override
            public int apply(IGraphicalEditPart firstPart, IGraphicalEditPart lastPart) {
                return Math.round((float)((Integer)this.getFirstPartMainAxisFunction.apply((Object)lastPart) - (Integer)this.getLastPartMainAxisFunction.apply((Object)firstPart)) / (float)(this.partsToDistribute.size() - 1));
            }
        });
    }

    private void distribute(Collection<IGraphicalEditPart> partsToDistribute, Function<IGraphicalEditPart, Integer> getFirstPartMainAxisFunction, Function<IGraphicalEditPart, Integer> getFirstPartSecondAxisFunction, Function<IGraphicalEditPart, Integer> getLastPartMainAxisFunction, Function<IGraphicalEditPart, Integer> getLastPartSecondAxisFunction, Comparator<IGraphicalEditPart> comparator, GetNewBoundsFunction getNewBoundsFunction, Function<IGraphicalEditPart, Rectangle> getBoundsFunction, GetGapFunction getGapFunction) {
        int firstPartMainAxis = 0;
        int firstPartSecondAxis = 0;
        int lastPartMainAxis = 0;
        int lastPartSecondAxis = 0;
        Object firstPart = null;
        IGraphicalEditPart lastPart = null;
        for (IGraphicalEditPart part : partsToDistribute) {
            if (firstPart == null || (Integer)getFirstPartMainAxisFunction.apply((Object)part) < firstPartMainAxis || (Integer)getFirstPartMainAxisFunction.apply((Object)part) == firstPartMainAxis && (Integer)getFirstPartSecondAxisFunction.apply((Object)part) < firstPartSecondAxis) {
                firstPart = part;
                firstPartMainAxis = (Integer)getFirstPartMainAxisFunction.apply((Object)part);
                firstPartSecondAxis = (Integer)getFirstPartSecondAxisFunction.apply((Object)part);
            }
            if (lastPart != null && (Integer)getLastPartMainAxisFunction.apply((Object)part) <= lastPartMainAxis && ((Integer)getLastPartMainAxisFunction.apply((Object)part) != lastPartMainAxis || (Integer)getLastPartSecondAxisFunction.apply((Object)part) <= lastPartSecondAxis)) continue;
            lastPart = part;
            lastPartMainAxis = (Integer)getLastPartMainAxisFunction.apply((Object)part);
            lastPartSecondAxis = (Integer)getLastPartSecondAxisFunction.apply((Object)part);
        }
        if (firstPart.equals(lastPart)) {
            return;
        }
        int gap = getGapFunction.apply((IGraphicalEditPart)firstPart, lastPart);
        ArrayList partsToMove = Lists.newArrayList(partsToDistribute);
        partsToMove.remove(firstPart);
        partsToMove.remove(lastPart);
        Collections.sort(partsToMove, comparator);
        Rectangle previousPartBounds = (Rectangle)getBoundsFunction.apply(firstPart);
        if (!(partsToMove.get(0) instanceof IBorderItemEditPart)) {
            for (IGraphicalEditPart editPart : partsToMove) {
                Rectangle newBounds = getNewBoundsFunction.apply(editPart, previousPartBounds, gap);
                EObjectAdapter adapter = new EObjectAdapter((EObject)((Node)editPart.getModel()));
                this.wrappedCommand.compose((IUndoableOperation)new SetBoundsCommand(this.wrappedCommand.getEditingDomain(), this.wrappedCommand.getLabel(), (IAdaptable)adapter, newBounds));
                previousPartBounds = newBounds;
            }
        } else {
            HashMap partToFigureToIgnore = Maps.newHashMap();
            ArrayList additionalFiguresForConflictsDetection = Lists.newArrayList();
            for (IGraphicalEditPart editPart : partsToMove) {
                partToFigureToIgnore.put(editPart, editPart.getFigure());
            }
            for (IGraphicalEditPart editPart : partsToMove) {
                Rectangle expectedNewBounds = getNewBoundsFunction.apply(editPart, previousPartBounds, gap);
                Rectangle newBounds = expectedNewBounds.getCopy();
                if (editPart instanceof IBorderItemEditPart) {
                    IBorderItemEditPart borderEditPart = (IBorderItemEditPart)editPart;
                    IBorderItemLocator borderItemLocator = borderEditPart.getBorderItemLocator();
                    newBounds = borderItemLocator instanceof DBorderItemLocator ? ((DBorderItemLocator)borderItemLocator).getValidLocation(newBounds, editPart.getFigure(), partToFigureToIgnore.values(), additionalFiguresForConflictsDetection) : borderItemLocator.getValidLocation(newBounds, editPart.getFigure());
                    partToFigureToIgnore.remove(editPart);
                    editPart.getFigure().setBounds(newBounds);
                    additionalFiguresForConflictsDetection.add(editPart.getFigure());
                }
                Dimension delta = newBounds.getLocation().getDifference(((Rectangle)getBoundsFunction.apply((Object)editPart)).getLocation());
                if (delta.width != 0) {
                    this.wrappedCommand.compose((IUndoableOperation)CommandFactory.createICommand(this.wrappedCommand.getEditingDomain(), new ShiftDirectBorderedNodesOperation(Lists.newArrayList((Object[])new Node[]{(Node)editPart.getModel()}), new Dimension(delta.width, 0))));
                } else {
                    this.wrappedCommand.compose((IUndoableOperation)CommandFactory.createICommand(this.wrappedCommand.getEditingDomain(), new ShiftDirectBorderedNodesOperation(Lists.newArrayList((Object[])new Node[]{(Node)editPart.getModel()}), new Dimension(0, delta.height))));
                }
                previousPartBounds = expectedNewBounds;
            }
        }
    }

    public boolean canUndo() {
        if (this.wrappedCommand.size() > 0 && this.wrappedCommand != null) {
            return this.wrappedCommand.canUndo();
        }
        return true;
    }

    public boolean canRedo() {
        if (this.wrappedCommand.size() > 0 && this.wrappedCommand != null) {
            return this.wrappedCommand.canRedo();
        }
        return true;
    }

    public void dispose() {
        this.editPartsToDistribute = null;
        this.wrappedCommand = null;
    }

    public abstract class FunctionWithBounds
    implements Function<IGraphicalEditPart, Integer> {
        HashMap<IGraphicalEditPart, Rectangle> partsToBounds;

        public FunctionWithBounds(HashMap<IGraphicalEditPart, Rectangle> partsToBounds) {
            this.partsToBounds = partsToBounds;
        }

        public Integer apply(IGraphicalEditPart input) {
            return this.apply(this.partsToBounds.get(input));
        }

        protected abstract Integer apply(Rectangle var1);
    }

    public class GetBottomFunction
    extends FunctionWithBounds {
        public GetBottomFunction(HashMap<IGraphicalEditPart, Rectangle> partsToBounds) {
            super(partsToBounds);
        }

        @Override
        protected Integer apply(Rectangle rectangle) {
            return rectangle.getBottom().y;
        }
    }

    public class GetCenterFunction
    extends FunctionWithBounds {
        public GetCenterFunction(HashMap<IGraphicalEditPart, Rectangle> partsToBounds) {
            super(partsToBounds);
        }

        @Override
        protected Integer apply(Rectangle rectangle) {
            return rectangle.getCenter().x;
        }
    }

    public abstract class GetGapFunction {
        protected Set<IGraphicalEditPart> partsToDistribute;
        protected Function<IGraphicalEditPart, Integer> getFirstPartMainAxisFunction;
        protected Function<IGraphicalEditPart, Integer> getLastPartMainAxisFunction;
        protected Function<IGraphicalEditPart, Integer> getSizeFunction;

        public GetGapFunction(Set<IGraphicalEditPart> partsToDistribute, Function<IGraphicalEditPart, Integer> getFirstPartMainAxisFunction, Function<IGraphicalEditPart, Integer> getLastPartMainAxisFunction, Function<IGraphicalEditPart, Integer> getSizeFunction) {
            this.partsToDistribute = partsToDistribute;
            this.getFirstPartMainAxisFunction = getFirstPartMainAxisFunction;
            this.getLastPartMainAxisFunction = getLastPartMainAxisFunction;
            this.getSizeFunction = getSizeFunction;
        }

        public abstract int apply(IGraphicalEditPart var1, IGraphicalEditPart var2);
    }

    public class GetHeightFunction
    extends FunctionWithBounds {
        public GetHeightFunction(HashMap<IGraphicalEditPart, Rectangle> partsToBounds) {
            super(partsToBounds);
        }

        @Override
        protected Integer apply(Rectangle rectangle) {
            return rectangle.height;
        }
    }

    public class GetLeftFunction
    extends FunctionWithBounds {
        public GetLeftFunction(HashMap<IGraphicalEditPart, Rectangle> partsToBounds) {
            super(partsToBounds);
        }

        @Override
        protected Integer apply(Rectangle rectangle) {
            return rectangle.x;
        }
    }

    public class GetMiddleFunction
    extends FunctionWithBounds {
        public GetMiddleFunction(HashMap<IGraphicalEditPart, Rectangle> partsToBounds) {
            super(partsToBounds);
        }

        @Override
        protected Integer apply(Rectangle rectangle) {
            return rectangle.getCenter().y;
        }
    }

    public abstract class GetNewBoundsFunction
    implements Function<IGraphicalEditPart, Rectangle> {
        protected int gap;
        protected Rectangle previousPartBounds;

        public Rectangle apply(IGraphicalEditPart input, Rectangle previousPartBounds, int gap) {
            this.gap = gap;
            this.previousPartBounds = previousPartBounds;
            return (Rectangle)this.apply(input);
        }
    }

    public class GetRightFunction
    extends FunctionWithBounds {
        public GetRightFunction(HashMap<IGraphicalEditPart, Rectangle> partsToBounds) {
            super(partsToBounds);
        }

        @Override
        protected Integer apply(Rectangle rectangle) {
            return rectangle.getRight().x;
        }
    }

    public class GetTopFunction
    extends FunctionWithBounds {
        public GetTopFunction(HashMap<IGraphicalEditPart, Rectangle> partsToBounds) {
            super(partsToBounds);
        }

        @Override
        protected Integer apply(Rectangle rectangle) {
            return rectangle.y;
        }
    }

    public class GetWidthFunction
    extends FunctionWithBounds {
        public GetWidthFunction(HashMap<IGraphicalEditPart, Rectangle> partsToBounds) {
            super(partsToBounds);
        }

        @Override
        protected Integer apply(Rectangle rectangle) {
            return rectangle.width;
        }
    }

    public class PartByCenter
    implements Comparator<IGraphicalEditPart> {
        HashMap<IGraphicalEditPart, Rectangle> partToBounds;

        public PartByCenter(HashMap<IGraphicalEditPart, Rectangle> partToBounds) {
            this.partToBounds = partToBounds;
        }

        @Override
        public int compare(IGraphicalEditPart part1, IGraphicalEditPart part2) {
            Integer a = this.partToBounds.get((Object)part1).getCenter().x;
            Integer b = this.partToBounds.get((Object)part2).getCenter().x;
            return a.compareTo(b);
        }
    }

    public class PartByMiddle
    implements Comparator<IGraphicalEditPart> {
        HashMap<IGraphicalEditPart, Rectangle> partToBounds;

        public PartByMiddle(HashMap<IGraphicalEditPart, Rectangle> partToBounds) {
            this.partToBounds = partToBounds;
        }

        @Override
        public int compare(IGraphicalEditPart part1, IGraphicalEditPart part2) {
            Integer a = this.partToBounds.get((Object)part1).getCenter().y;
            Integer b = this.partToBounds.get((Object)part2).getCenter().y;
            return a.compareTo(b);
        }
    }
}

