/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.workspace.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.sapphire.workspace.ProjectRelativePath;

public final class ProjectRelativePathValidationService
extends ValidationService {
    @Text(value="No context project found")
    private static LocalizableText message;

    static {
        LocalizableText.init(ProjectRelativePathValidationService.class);
    }

    protected Status compute() {
        IProject project;
        Element element = (Element)this.context(Element.class);
        if (element.property((ValueProperty)this.context(ValueProperty.class)).text() != null && (project = (IProject)element.adapt(IProject.class)) == null) {
            return Status.createErrorStatus((String)message.text());
        }
        return Status.createOkStatus();
    }

    public static final class Condition
    extends ServiceCondition {
        public boolean applicable(ServiceContext context) {
            ValueProperty property = (ValueProperty)context.find(ValueProperty.class);
            return property != null && Path.class.isAssignableFrom(property.getTypeClass()) && property.hasAnnotation(ProjectRelativePath.class);
        }
    }
}

